/*
 * Decompiled with CFR 0.152.
 */
package com.roncoo.fastdfs;

import com.roncoo.fastdfs.TrackerServer;
import java.io.IOException;
import java.net.InetSocketAddress;

public class TrackerGroup {
    public int tracker_server_index;
    public InetSocketAddress[] tracker_servers;
    protected Integer lock;

    public TrackerGroup(InetSocketAddress[] tracker_servers) {
        this.tracker_servers = tracker_servers;
        this.lock = new Integer(0);
        this.tracker_server_index = 0;
    }

    public TrackerServer getTrackerServer(int serverIndex) throws IOException {
        return new TrackerServer(this.tracker_servers[serverIndex]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackerServer getTrackerServer() throws IOException {
        int current_index;
        Integer n = this.lock;
        synchronized (n) {
            ++this.tracker_server_index;
            if (this.tracker_server_index >= this.tracker_servers.length) {
                this.tracker_server_index = 0;
            }
            current_index = this.tracker_server_index;
        }
        try {
            return this.getTrackerServer(current_index);
        }
        catch (IOException ex) {
            System.err.println("connect to server " + this.tracker_servers[current_index].getAddress().getHostAddress() + ":" + this.tracker_servers[current_index].getPort() + " fail");
            ex.printStackTrace(System.err);
            for (int i = 0; i < this.tracker_servers.length; ++i) {
                if (i == current_index) continue;
                try {
                    TrackerServer trackerServer = this.getTrackerServer(i);
                    Integer n2 = this.lock;
                    synchronized (n2) {
                        if (this.tracker_server_index == current_index) {
                            this.tracker_server_index = i;
                        }
                    }
                    return trackerServer;
                }
                catch (IOException ex2) {
                    System.err.println("connect to server " + this.tracker_servers[i].getAddress().getHostAddress() + ":" + this.tracker_servers[i].getPort() + " fail");
                    ex2.printStackTrace(System.err);
                }
            }
            return null;
        }
    }

    public Object clone() {
        InetSocketAddress[] trackerServers = new InetSocketAddress[this.tracker_servers.length];
        for (int i = 0; i < trackerServers.length; ++i) {
            trackerServers[i] = new InetSocketAddress(this.tracker_servers[i].getAddress().getHostAddress(), this.tracker_servers[i].getPort());
        }
        return new TrackerGroup(trackerServers);
    }
}

