/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.javaee.servlet.response.mapper;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ConstraintViolatedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.AbstractResponseMapper;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

public class ConstraintViolationExceptionMapper
extends AbstractResponseMapper<ConstraintViolationException> {
    public Class<ConstraintViolationException> getThrowableClass() {
        return ConstraintViolationException.class;
    }

    public ResponseWithErrorCode toResponse(Throwable throwable) {
        return new ConstraintViolatedResponse(this.getErrorMessage(throwable));
    }

    public LogLevel getLogLevel(Throwable throwable) {
        return LogLevel.WARNING;
    }

    public String getErrorMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(throwable.getMessage());
        Set constraintViolations = ((ConstraintViolationException)throwable).getConstraintViolations();
        if (!constraintViolations.isEmpty()) {
            ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
            stringBuilder.append(" Details: ").append(violation.getMessage()).append(". ");
        }
        return stringBuilder.toString();
    }
}

