/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.HashSet;
import java.util.logging.Level;

public class SecondaryCursor
extends Cursor {
    private final SecondaryDatabase secondaryDb;

    SecondaryCursor(SecondaryDatabase dbHandle, Transaction txn, CursorConfig cursorConfig) {
        super((Database)dbHandle, txn, cursorConfig);
        this.secondaryDb = dbHandle;
    }

    SecondaryCursor(SecondaryDatabase dbHandle, Locker locker, CursorConfig cursorConfig) {
        super((Database)dbHandle, locker, cursorConfig);
        this.secondaryDb = dbHandle;
    }

    private SecondaryCursor(SecondaryCursor cursor, boolean samePosition) {
        super(cursor, samePosition);
        this.secondaryDb = cursor.secondaryDb;
    }

    @Override
    boolean isSecondaryCursor() {
        return true;
    }

    @Override
    public SecondaryDatabase getDatabase() {
        return this.secondaryDb;
    }

    public Database getPrimaryDatabase() {
        return this.secondaryDb.getPrimaryDatabase();
    }

    @Override
    public SecondaryCursor dup(boolean samePosition) {
        this.checkOpenAndState(false);
        return new SecondaryCursor(this, samePosition);
    }

    public SecondaryCursor dupSecondary(boolean samePosition) {
        return this.dup(samePosition);
    }

    @Override
    public OperationResult delete(WriteOptions options) {
        this.checkOpenAndState(true);
        this.trace(Level.FINEST, "SecondaryCursor.delete: ", null);
        CacheMode cacheMode = options != null ? options.getCacheMode() : null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry pKey = new DatabaseEntry();
        OperationResult secResult = this.getCurrentInternal(key, pKey, LockMode.RMW, cacheMode);
        if (secResult == null) {
            return null;
        }
        Locker locker = this.cursorImpl.getLocker();
        Database primaryDb = this.secondaryDb.getPrimary(pKey);
        if (primaryDb == null) {
            this.deleteNoNotify(cacheMode, this.getDatabaseImpl().getRepContext());
            return secResult;
        }
        OperationResult priResult = primaryDb.deleteInternal(locker, pKey, cacheMode);
        if (priResult != null) {
            return priResult;
        }
        if (this.cursorImpl.isProbablyExpired()) {
            return null;
        }
        throw this.secondaryDb.secondaryRefersToMissingPrimaryKey(locker, primaryDb, key, pKey, secResult.getExpirationTime());
    }

    @Override
    public OperationStatus delete() {
        OperationResult result = this.delete(null);
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    @Override
    public OperationResult put(DatabaseEntry key, DatabaseEntry data, Put putType, WriteOptions options) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putCurrent(DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationResult get(DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        return this.get(key, null, data, getType, options);
    }

    public OperationResult get(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Get getType, ReadOptions options) {
        try {
            this.checkOpen();
            if (options == null) {
                options = DEFAULT_READ_OPTIONS;
            }
            LockMode lockMode = options.getLockMode();
            this.trace(Level.FINEST, "SecondaryCursor.get: ", String.valueOf((Object)getType), key, data, lockMode);
            return this.getInternal(key, pKey, data, getType, options, lockMode);
        }
        catch (Error E) {
            this.getDatabaseImpl().getEnv().invalidate(E);
            throw E;
        }
    }

    OperationResult getInternal(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Get getType, ReadOptions options, LockMode lockMode) {
        DatabaseUtil.checkForNullParam((Object)getType, "getType");
        if (data == null) {
            data = NO_RETURN_DATA;
        }
        CacheMode cacheMode = options.getCacheMode();
        SearchMode searchMode = getType.getSearchMode();
        if (searchMode != null) {
            this.checkState(false);
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForPartial(key, "key");
            if (searchMode.isDataSearch() || searchMode == SearchMode.ANY_RANGE && this.getDatabaseImpl().getSortedDuplicates()) {
                DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
                DatabaseUtil.checkForPartial(pKey, "pKey");
            } else if (pKey == null) {
                pKey = new DatabaseEntry();
            }
            return this.search(key, pKey, data, lockMode, cacheMode, searchMode);
        }
        if (key == null) {
            key = NO_RETURN_DATA;
        }
        if (pKey == null) {
            pKey = new DatabaseEntry();
        }
        GetMode getMode = getType.getGetMode();
        if (getType.getAllowNextPrevUninitialized() && this.cursorImpl.isNotInitialized()) {
            assert (getMode != null);
            getType = getMode.isForward() ? Get.FIRST : Get.LAST;
            getMode = null;
        }
        if (getMode != null) {
            this.checkState(true);
            return this.retrieveNext(key, pKey, data, lockMode, cacheMode, getMode, this.getLockPrimaryOnly(lockMode, data));
        }
        if (getType == Get.CURRENT) {
            this.checkState(true);
            return this.getCurrentInternal(key, pKey, data, lockMode, cacheMode);
        }
        assert (getType == Get.FIRST || getType == Get.LAST);
        this.checkState(false);
        return this.position(key, pKey, data, lockMode, cacheMode, getType == Get.FIRST, this.getLockPrimaryOnly(lockMode, data));
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getCurrent(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.CURRENT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getFirst(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.FIRST, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getLast(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.LAST, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getNext(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.NEXT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getNextDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.NEXT_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getNextNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.NEXT_NO_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getPrev(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.PREV, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getPrevDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.PREV_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getPrevNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.PREV_NO_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getSearchKey(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.getSearchKeyRange(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.SEARCH_GTE, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.SEARCH_BOTH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, pKey, data, Get.SEARCH_BOTH_GTE, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    private OperationResult getCurrentInternal(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationResult result = this.getCurrentInternal(key, pKey, searchLockMode, cacheMode);
        if (result == null) {
            return null;
        }
        return this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly, result);
    }

    OperationResult search(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode) {
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationResult result1 = this.search(key, pKey, searchLockMode, cacheMode, searchMode, true);
        if (result1 == null) {
            return null;
        }
        OperationResult result2 = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly, result1);
        if (result2 != null) {
            return result2;
        }
        switch (searchMode) {
            case BOTH: {
                return null;
            }
            case SET: 
            case BOTH_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, cacheMode, GetMode.NEXT_DUP, lockPrimaryOnly);
            }
            case SET_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, cacheMode, GetMode.NEXT, lockPrimaryOnly);
            }
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    private OperationResult position(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, boolean first, boolean lockPrimaryOnly) {
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationResult result1 = this.position(key, pKey, searchLockMode, cacheMode, first);
        if (result1 == null) {
            return null;
        }
        OperationResult result2 = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly, result1);
        if (result2 != null) {
            return result2;
        }
        return this.retrieveNext(key, pKey, data, lockMode, cacheMode, first ? GetMode.NEXT : GetMode.PREV, lockPrimaryOnly);
    }

    private OperationResult retrieveNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getMode, boolean lockPrimaryOnly) {
        OperationResult result1;
        OperationResult result2;
        LockMode searchLockMode;
        LockMode lockMode2 = searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        do {
            if ((result1 = this.retrieveNext(key, pKey, searchLockMode, cacheMode, getMode)) != null) continue;
            return null;
        } while ((result2 = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly, result1)) == null);
        return result2;
    }

    private boolean getLockPrimaryOnly(LockMode lockMode, DatabaseEntry data) {
        boolean dataRequested = data != null && (!data.getPartial() || data.getPartialLength() != 0);
        return dataRequested && !this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode);
    }

    private OperationResult readPrimaryAfterGet(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secDirtyRead, boolean lockPrimaryOnly, OperationResult origResult) {
        Database primaryDb = this.secondaryDb.getPrimary(pKey);
        if (primaryDb == null) {
            return null;
        }
        if (!this.readPrimaryAfterGet(primaryDb, key, pKey, data, lockMode, secDirtyRead, lockPrimaryOnly, false, this.cursorImpl.getLocker(), this.secondaryDb, null)) {
            return null;
        }
        if (!secDirtyRead) {
            return origResult;
        }
        return DbInternal.makeResult(this.cursorImpl.getExpirationTime());
    }

    @Override
    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        SecondaryConfig conf = this.secondaryDb.getPrivateSecondaryConfig();
        boolean possibleIntegrityError = false;
        if (!conf.getImmutableSecondaryKey()) {
            if (conf.getKeyCreator() != null) {
                DatabaseEntry secKey = new DatabaseEntry();
                if (!conf.getKeyCreator().createSecondaryKey(this.secondaryDb, pKey, data, secKey) || !secKey.equals(key)) {
                    possibleIntegrityError = true;
                }
            } else if (conf.getMultiKeyCreator() != null) {
                HashSet<DatabaseEntry> results = new HashSet<DatabaseEntry>();
                conf.getMultiKeyCreator().createSecondaryKeys(this.secondaryDb, pKey, data, results);
                if (!results.contains(key)) {
                    possibleIntegrityError = true;
                }
            }
        }
        return possibleIntegrityError;
    }
}

