/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.LN;

public enum DbType {
    ID("_jeIdMap"){

        @Override
        public boolean mayCreateDeletedLN() {
            return false;
        }

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            throw EnvironmentFailureException.unexpectedState();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }
    ,
    NAME("_jeNameMap"){

        @Override
        public boolean mayCreateDeletedLN() {
            return false;
        }

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            throw EnvironmentFailureException.unexpectedState();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }

        @Override
        public boolean isMixedReplication() {
            return true;
        }
    }
    ,
    UTILIZATION("_jeUtilization"){

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            return FileSummaryLN.makeDeletedLN();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }
    ,
    EXPIRATION("_jeExpiration"),
    REP_GROUP("_jeRepGroupDB"),
    VLSN_MAP("_jeVlsnMapDb"),
    SYNC("_jeSyncDb"),
    RESERVED_FILES("_jeReservedFilesDb"){

        @Override
        public LogEntryType getLogType(boolean isTransactional) {
            return LogEntryType.LOG_RESERVED_FILE_LN;
        }
    }
    ,
    EXTINCT_SCANS("_jeExtinctScansDb"){

        @Override
        public LogEntryType getLogType(boolean isTransactional) {
            return isTransactional ? LogEntryType.LOG_EXTINCT_SCAN_LN_TRANSACTIONAL : LogEntryType.LOG_EXTINCT_SCAN_LN;
        }

        @Override
        public boolean isMixedReplication() {
            return true;
        }
    }
    ,
    METADATA("_jeMetadata"),
    USER(null);

    private final String internalName;

    private DbType(String internalName) {
        this.internalName = internalName;
    }

    public boolean isInternal() {
        return this.internalName != null;
    }

    public String getInternalName() {
        if (this.internalName == null) {
            throw EnvironmentFailureException.unexpectedState();
        }
        return this.internalName;
    }

    public boolean isMixedReplication() {
        return false;
    }

    public boolean mayCreateUpdatedLN() {
        return true;
    }

    public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
        return LN.makeLN(envImpl, newData);
    }

    public boolean mayCreateDeletedLN() {
        return true;
    }

    public LN createDeletedLN(EnvironmentImpl envImpl) {
        return LN.makeLN(envImpl, (byte[])null);
    }

    public LogEntryType getLogType(boolean isTransactional) {
        return null;
    }
}

