/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Get;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.Put;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.utilint.StringUtils;

public class MetadataStore {
    public static final String KEY_ERASER = "eraser";
    private final EnvironmentImpl envImpl;
    private DatabaseImpl db;

    MetadataStore(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    public synchronized void openDb() {
        if (this.db != null) {
            return;
        }
        this.db = this.envImpl.getDbTree().openNonRepInternalDB(DbType.METADATA);
    }

    /*
     * Loose catch block
     */
    public OperationResult get(String key, DatabaseEntry data) {
        this.openDb();
        DatabaseEntry keyEntry = new DatabaseEntry(StringUtils.toUTF8(key));
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        try {
            try (Cursor cursor = DbInternal.makeCursor(this.db, (Locker)locker, null);){
                OperationResult operationResult = cursor.get(keyEntry, data, Get.NEXT, null);
                return operationResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            locker.operationEnd();
        }
    }

    /*
     * Loose catch block
     */
    public OperationResult put(String key, DatabaseEntry data) {
        this.openDb();
        DatabaseEntry keyEntry = new DatabaseEntry(StringUtils.toUTF8(key));
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        try {
            try (Cursor cursor = DbInternal.makeCursor(this.db, (Locker)locker, null);){
                OperationResult operationResult = cursor.put(keyEntry, data, Put.OVERWRITE, null);
                return operationResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            locker.operationEnd();
        }
    }
}

