/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class ErasedLogEntry
implements LogEntry {
    private boolean allZeros;

    @Override
    public int getSize() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void writeEntry(ByteBuffer logBuffer) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public boolean isImmediatelyObsolete(DatabaseImpl dbImpl) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn, VLSN vlsn) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public ErasedLogEntry clone() {
        try {
            return (ErasedLogEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    @Override
    public void setLogType(LogEntryType entryType) {
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_ERASED;
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        byte[] buf = new byte[100];
        int remaining = header.getItemSize();
        this.allZeros = true;
        while (remaining > 0) {
            int size = Math.min(remaining, buf.length);
            entryBuffer.get(buf, 0, size);
            remaining -= size;
            for (int i = 0; i < size; ++i) {
                if (buf[i] == 0) continue;
                this.allZeros = false;
            }
        }
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        sb.append("<Erased allZeros=\"").append(this.allZeros).append("\"/>");
        return sb;
    }

    public boolean isAllZeros() {
        return this.allZeros;
    }

    @Override
    public Object getMainItem() {
        return null;
    }

    @Override
    public Object getResolvedItem(DatabaseImpl dbImpl) {
        return null;
    }

    @Override
    public DatabaseId getDbId() {
        return null;
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return false;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }
}

