/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.util.verify.BtreeVerifier;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class DbVerify {
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbVerify.class) + "\n      -h <dir>             # environment home directory\n      [-c ]                # check cleaner metadata\n      [-q ]                # quiet, exit with success or failure\n      [-s <databaseName>]  # database to verify\n      [-v <interval>]      # progress notification interval\n      [-bs <size>]         # how many records to check each batch\n      [-d <millis>]        # delay in ms between batches\n      [-vdr]               # verify data records (read LNs)\n      [-V]                 # print JE version number";
    File envHome = null;
    Environment env;
    String dbName = null;
    private VerifyConfig verifyConfig = new VerifyConfig();

    public static void main(String[] argv) throws DatabaseException {
        DbVerify verifier = new DbVerify();
        verifier.parseArgs(argv);
        boolean ret = false;
        try {
            verifier.openEnv();
            ret = verifier.verify(System.err);
            verifier.closeEnv();
        }
        catch (Throwable T) {
            T.printStackTrace(System.err);
        }
        if (verifier.verifyConfig.getPrintInfo() || verifier.verifyConfig.getShowProgressInterval() > 0) {
            System.err.println("Exit status = " + ret);
        }
        System.exit(ret ? 0 : -1);
    }

    DbVerify() {
    }

    public DbVerify(Environment env, String dbName, boolean quiet) {
        this.env = env;
        this.dbName = dbName;
        this.verifyConfig.setPrintInfo(!quiet);
    }

    void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    void parseArgs(String[] argv) {
        this.verifyConfig.setPrintInfo(true);
        this.verifyConfig.setBatchDelay(0L, TimeUnit.MILLISECONDS);
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.verifyConfig.setPrintInfo(false);
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (thisArg.equals("-v")) {
                if (argc < nArgs) {
                    int progressInterval;
                    if ((progressInterval = Integer.parseInt(argv[argc++])) <= 0) {
                        this.printUsage("-v requires a positive argument");
                    }
                    this.verifyConfig.setShowProgressInterval(progressInterval);
                    continue;
                }
                this.printUsage("-v requires an argument");
                continue;
            }
            if (thisArg.equals("-bs")) {
                if (argc < nArgs) {
                    int batchSize;
                    if ((batchSize = Integer.parseInt(argv[argc++])) <= 0) {
                        this.printUsage("-bs requires a positive argument");
                    }
                    this.verifyConfig.setBatchSize(batchSize);
                    continue;
                }
                this.printUsage("-bs requires an argument");
                continue;
            }
            if (thisArg.equals("-d")) {
                if (argc < nArgs) {
                    long delayMs;
                    if ((delayMs = Long.parseLong(argv[argc++])) < 0L) {
                        this.printUsage("-d requires a positive argument");
                    }
                    this.verifyConfig.setBatchDelay(delayMs, TimeUnit.MILLISECONDS);
                    continue;
                }
                this.printUsage("-d requires an argument");
                continue;
            }
            if (thisArg.equals("-vdr")) {
                this.verifyConfig.setVerifyDataRecords(true);
                continue;
            }
            if (!thisArg.equals("-vor")) continue;
            this.verifyConfig.setVerifyObsoleteRecords(true);
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    void openEnv() throws Exception {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(true);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    void closeEnv() {
        try {
            if (this.env != null) {
                this.env.close();
            }
        }
        finally {
            this.env = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(PrintStream out) throws DatabaseException {
        block5: {
            DatabaseImpl dbImpl;
            DbTree dbTree;
            BasicLocker locker;
            BtreeVerifier verifier;
            block3: {
                boolean bl;
                EnvironmentImpl envImpl;
                block4: {
                    envImpl = DbInternal.getNonNullEnvImpl(this.env);
                    verifier = new BtreeVerifier(envImpl);
                    this.verifyConfig.setShowProgressStream(out);
                    verifier.setBtreeVerifyConfig(this.verifyConfig);
                    if (this.dbName != null) break block4;
                    verifier.verifyAll();
                    break block5;
                }
                locker = BasicLocker.createBasicLocker(envImpl, false);
                dbTree = envImpl.getDbTree();
                dbImpl = null;
                try {
                    dbImpl = dbTree.getDb(locker, this.dbName, null, false);
                    if (dbImpl != null) break block3;
                    bl = true;
                    dbTree.releaseDb(dbImpl);
                }
                catch (Throwable throwable) {
                    dbTree.releaseDb(dbImpl);
                    locker.operationEnd();
                    throw throwable;
                }
                locker.operationEnd();
                return bl;
            }
            DatabaseId dbId = dbImpl.getId();
            dbTree.releaseDb(dbImpl);
            locker.operationEnd();
            verifier.verifyDatabase(this.dbName, dbId);
        }
        return true;
    }
}

