/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util.verify;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.RestoreMarker;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Properties;

public class VerifierUtils {
    private static final String EXCEPTION_KEY = "ex";
    private static final String RESTORE_REQUIRED_MSG = "The environment may not be opened due to persistent data corruption that was detected earlier. The marker file (7fffffff.jdb) may be deleted to allow recovery, but this is normally unsafe and not recommended. Original exception:\n";

    public static EnvironmentFailureException createMarkerFileFromException(RestoreRequired.FailureType failureType, Throwable origException, EnvironmentImpl envImpl, EnvironmentFailureReason reason) {
        String markerFileError = "";
        if (!envImpl.isReadOnly()) {
            Properties props = new Properties();
            props.setProperty(EXCEPTION_KEY, origException.toString() + "\n" + LoggerUtils.getStackTrace(origException));
            RestoreMarker restoreMarker = new RestoreMarker(envImpl.getFileManager(), envImpl.getLogManager());
            try {
                restoreMarker.createMarkerFile(failureType, props);
            }
            catch (RestoreMarker.FileCreationException e) {
                markerFileError = " " + e.getMessage();
            }
        }
        return new EnvironmentFailureException(envImpl, reason, "Persistent corruption detected: " + origException.toString() + markerFileError, origException);
    }

    public static String getRestoreRequiredMessage(RestoreRequired restoreRequired) {
        Properties p = restoreRequired.getProperties();
        return RESTORE_REQUIRED_MSG + p.get(EXCEPTION_KEY);
    }
}

