/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongComponent
extends MapStatComponent<Long, AtomicLongComponent> {
    final AtomicLong val;

    AtomicLongComponent() {
        this.val = new AtomicLong();
    }

    private AtomicLongComponent(long val) {
        this.val = new AtomicLong(val);
    }

    public void set(long newValue) {
        this.val.set(newValue);
    }

    public void add(long inc) {
        this.val.addAndGet(inc);
    }

    @Override
    public Long get() {
        return this.val.get();
    }

    @Override
    public void clear() {
        this.val.set(0L);
    }

    @Override
    public AtomicLongComponent copy() {
        return new AtomicLongComponent(this.val.get());
    }

    @Override
    protected String getFormattedValue(boolean useCommas) {
        if (useCommas) {
            return FormatUtil.decimalScale0().format(this.val.get());
        }
        return this.val.toString();
    }

    @Override
    public boolean isNotSet() {
        return this.val.get() == 0L;
    }

    public String toString() {
        return this.val.toString();
    }
}

