/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongAvg;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StatWithValueType;

public class LongAvgStat
extends StatWithValueType<Long> {
    private static final long serialVersionUID = 1L;
    private final LongAvg avg;

    public LongAvgStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        if (definition.getType() != StatDefinition.StatType.INCREMENTAL) {
            throw new IllegalArgumentException("The stat type must be INCREMENTAL, found: " + (Object)((Object)definition.getType()));
        }
        this.avg = new LongAvg();
    }

    private LongAvgStat(LongAvgStat other) {
        this(other.definition, other.avg);
    }

    private LongAvgStat(StatDefinition definition, LongAvg avg) {
        super(definition);
        this.avg = avg.copy();
    }

    public void add(long value) {
        this.avg.add(value);
    }

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    @Override
    public void set(Long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Stat<Long> other) {
        if (!(other instanceof LongAvgStat)) {
            throw new IllegalArgumentException("Other stat must be a LongAvgStat, found: " + other);
        }
        this.avg.add(((LongAvgStat)other).avg);
    }

    @Override
    public Stat<Long> computeInterval(Stat<Long> base) {
        if (!(base instanceof LongAvgStat)) {
            throw new IllegalArgumentException("Other stat must be a LongAvgStat, found: " + base);
        }
        LongAvgStat baseAvg = (LongAvgStat)base;
        LongAvgStat result = this.copy();
        result.avg.updateInterval(baseAvg.avg);
        return result;
    }

    @Override
    public void negate() {
        this.avg.negate();
    }

    @Override
    public LongAvgStat copy() {
        return new LongAvgStat(this);
    }

    @Override
    public Long get() {
        return this.avg.get();
    }

    @Override
    public void clear() {
        this.avg.clear();
    }

    @Override
    protected String getFormattedValue() {
        return this.avg.getFormattedValue();
    }

    @Override
    public boolean isNotSet() {
        return this.avg.isNotSet();
    }
}

