/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.net.HostAndPort;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.docker.client.ExecNotFoundException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.LoggingBuildHandler;
import com.spotify.docker.client.LoggingPullHandler;
import com.spotify.docker.client.LoggingPushHandler;
import com.spotify.docker.client.LogsResponseReader;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.ProgressResponseReader;
import com.spotify.docker.client.ProgressStream;
import com.spotify.docker.client.UnixConnectionSocketFactory;
import com.spotify.docker.client.messages.AuthConfig;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ExecState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.spotify.docker.client.shaded.javax.ws.rs.ProcessingException;
import com.spotify.docker.client.shaded.javax.ws.rs.WebApplicationException;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Client;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientBuilder;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Entity;
import com.spotify.docker.client.shaded.javax.ws.rs.client.Invocation;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ResponseProcessingException;
import com.spotify.docker.client.shaded.javax.ws.rs.client.WebTarget;
import com.spotify.docker.client.shaded.javax.ws.rs.core.GenericType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MediaType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.internal.util.Base64;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDockerClient
implements DockerClient,
Closeable {
    public static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 2375;
    private static final String UNIX_SCHEME = "unix";
    private static final String VERSION = "v1.15";
    private static final Logger log = LoggerFactory.getLogger(DefaultDockerClient.class);
    public static final long NO_TIMEOUT = 0L;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 100;
    private static final ClientConfig DEFAULT_CONFIG = new ClientConfig(ObjectMapperProvider.class, JacksonFeature.class, LogsResponseReader.class, ProgressResponseReader.class);
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("/?[a-zA-Z0-9_-]+");
    private static final GenericType<List<Container>> CONTAINER_LIST = new GenericType<List<Container>>(){};
    private static final GenericType<List<Image>> IMAGE_LIST = new GenericType<List<Image>>(){};
    private static final GenericType<List<ImageSearchResult>> IMAGES_SEARCH_RESULT_LIST = new GenericType<List<ImageSearchResult>>(){};
    private static final GenericType<List<RemovedImage>> REMOVED_IMAGE_LIST = new GenericType<List<RemovedImage>>(){};
    private final Client client;
    private final Client noTimeoutClient;
    private final URI uri;
    private final AuthConfig authConfig;

    Client getClient() {
        return this.client;
    }

    Client getNoTimeoutClient() {
        return this.noTimeoutClient;
    }

    public DefaultDockerClient(String uri) {
        this(URI.create(uri.replaceAll("^unix:///", "unix://localhost/")));
    }

    public DefaultDockerClient(URI uri) {
        this(new Builder().uri(uri));
    }

    public DefaultDockerClient(URI uri, DockerCertificates dockerCertificates) {
        this(new Builder().uri(uri).dockerCertificates(dockerCertificates));
    }

    protected DefaultDockerClient(Builder builder) {
        URI originalUri = (URI)Preconditions.checkNotNull((Object)builder.uri, (Object)"uri");
        if (builder.dockerCertificates != null && !originalUri.getScheme().equals("https")) {
            throw new IllegalArgumentException("https URI must be provided to use certificates");
        }
        this.uri = originalUri.getScheme().equals(UNIX_SCHEME) ? UnixConnectionSocketFactory.sanitizeUri(originalUri) : originalUri;
        PoolingHttpClientConnectionManager cm = this.getConnectionManager(builder);
        PoolingHttpClientConnectionManager noTimeoutCm = this.getConnectionManager(builder);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)builder.connectTimeoutMillis).setConnectTimeout((int)builder.connectTimeoutMillis).setSocketTimeout((int)builder.readTimeoutMillis).build();
        ClientConfig config = DEFAULT_CONFIG.connectorProvider(new ApacheConnectorProvider()).property("jersey.config.apache.client.connectionManager", cm).property("jersey.config.apache.client.requestConfig", requestConfig);
        this.authConfig = builder.authConfig;
        this.client = ClientBuilder.newClient(config);
        RequestConfig noReadTimeoutRequestConfig = RequestConfig.copy((RequestConfig)requestConfig).setSocketTimeout(0).build();
        this.noTimeoutClient = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig(config).property("jersey.config.apache.client.connectionManager", noTimeoutCm)).property("jersey.config.apache.client.requestConfig", noReadTimeoutRequestConfig)).build();
    }

    @Override
    public String getHost() {
        return (String)Optional.fromNullable((Object)this.uri.getHost()).or((Object)DEFAULT_HOST);
    }

    private PoolingHttpClientConnectionManager getConnectionManager(Builder builder) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(builder));
        cm.setMaxTotal(builder.connectionPoolSize);
        cm.setDefaultMaxPerRoute(cm.getMaxTotal());
        return cm;
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(Builder builder) {
        SSLConnectionSocketFactory https = builder.dockerCertificates == null ? SSLConnectionSocketFactory.getSocketFactory() : new SSLConnectionSocketFactory(builder.dockerCertificates.sslContext(), builder.dockerCertificates.hostnameVerifier());
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("https", (Object)https).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (builder.uri.getScheme().equals(UNIX_SCHEME)) {
            registryBuilder.register(UNIX_SCHEME, (Object)new UnixConnectionSocketFactory(builder.uri));
        }
        return registryBuilder.build();
    }

    @Override
    public void close() {
        this.client.close();
        this.noTimeoutClient.close();
    }

    @Override
    public String ping() throws DockerException, InterruptedException {
        WebTarget resource = this.client.target(this.uri).path("_ping");
        return this.request("GET", String.class, resource, resource.request());
    }

    @Override
    public Version version() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("version");
        return this.request("GET", Version.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public int auth(AuthConfig authConfig) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("auth");
        Response response = this.request("POST", Response.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.json(authConfig));
        return response.getStatus();
    }

    @Override
    public Info info() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("info");
        return this.request("GET", Info.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public List<Container> listContainers(DockerClient.ListContainersParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("json");
        for (DockerClient.ListContainersParam param : params) {
            resource = resource.queryParam(param.name(), param.value());
        }
        return this.request("GET", CONTAINER_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public List<Image> listImages(DockerClient.ListImagesParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("json");
        HashMap filters = Maps.newHashMap();
        for (DockerClient.ListImagesParam param : params) {
            if (param instanceof DockerClient.ListImagesFilterParam) {
                filters.put(param.name(), param.value());
                continue;
            }
            resource = resource.queryParam(param.name(), param.value());
        }
        try {
            if (!filters.isEmpty()) {
                StringWriter writer = new StringWriter();
                JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator(writer);
                generator.writeStartObject();
                for (Map.Entry entry : filters.entrySet()) {
                    generator.writeArrayFieldStart((String)entry.getKey());
                    generator.writeString((String)entry.getValue());
                    generator.writeEndArray();
                }
                generator.writeEndObject();
                generator.close();
                String encoded = URLEncoder.encode(writer.toString(), StandardCharsets.UTF_8.name());
                resource = resource.queryParam("filters", encoded);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        return this.request("GET", IMAGE_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config) throws DockerException, InterruptedException {
        return this.createContainer(config, null);
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config, String name) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("create");
        if (name != null) {
            Preconditions.checkArgument((boolean)CONTAINER_NAME_PATTERN.matcher(name).matches(), (String)"Invalid container name: \"%s\"", (Object[])new Object[]{name});
            resource = resource.queryParam("name", name);
        }
        log.info("Creating container with ContainerConfig: {}", (Object)config);
        try {
            return this.request("POST", ContainerCreation.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.json(config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(config.image(), e);
                }
            }
            throw e;
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerException, InterruptedException {
        this.startContainer(containerId, HostConfig.builder().build());
    }

    @Override
    public void startContainer(String containerId, HostConfig hostConfig) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)hostConfig, (Object)"hostConfig");
        log.info("Starting container with HostConfig: {}", (Object)hostConfig);
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("start");
            this.request("POST", resource, resource.request(MediaType.APPLICATION_JSON_TYPE).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED), Entity.json(hostConfig));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void pauseContainer(String containerId) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("pause");
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void unpauseContainer(String containerId) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("unpause");
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void restartContainer(String containerId) throws DockerException, InterruptedException {
        this.restartContainer(containerId, 10);
    }

    @Override
    public void restartContainer(String containerId, int secondsToWaitBeforeRestart) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)secondsToWaitBeforeRestart, (Object)"secondsToWait");
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("restart").queryParam("t", String.valueOf(secondsToWaitBeforeRestart));
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void killContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("kill");
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void stopContainer(String containerId, int secondsToWaitBeforeKilling) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.noTimeoutResource().path("containers").path(containerId).path("stop").queryParam("t", String.valueOf(secondsToWaitBeforeKilling));
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 304: {
                    return;
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerExit waitContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.noTimeoutResource().path("containers").path(containerId).path("wait");
            return this.request("POST", ContainerExit.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeContainer(String containerId) throws DockerException, InterruptedException {
        this.removeContainer(containerId, false);
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId);
            this.request("DELETE", resource, resource.queryParam("v", String.valueOf(removeVolumes)).request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public InputStream exportContainer(String containerId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("export");
        return this.request("GET", InputStream.class, resource, resource.request(MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    @Override
    public InputStream copyContainer(String containerId, String path) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("copy");
        JsonNodeFactory nf = JsonNodeFactory.instance;
        JsonNode params = nf.objectNode().set("Resource", nf.textNode(path));
        return this.request("POST", InputStream.class, resource, resource.request(MediaType.APPLICATION_OCTET_STREAM_TYPE), Entity.json(params));
    }

    @Override
    public ContainerInfo inspectContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("json");
            return this.request("GET", ContainerInfo.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerCreation commitContainer(String containerId, String repo, String tag, ContainerConfig config, String comment, String author) throws DockerException, InterruptedException {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId");
        Preconditions.checkNotNull((Object)repo, (Object)"repo");
        Preconditions.checkNotNull((Object)config, (Object)"containerConfig");
        WebTarget resource = this.resource().path("commit").queryParam("container", containerId).queryParam("repo", repo).queryParam("comment", comment);
        if (!Strings.isNullOrEmpty((String)author)) {
            resource = resource.queryParam("author", author);
        }
        if (!Strings.isNullOrEmpty((String)comment)) {
            resource = resource.queryParam("comment", comment);
        }
        if (!Strings.isNullOrEmpty((String)tag)) {
            resource = resource.queryParam("tag", tag);
        }
        log.info("Committing container id: {} to repository: {} with ContainerConfig: {}", new Object[]{containerId, repo, config});
        try {
            return this.request("POST", ContainerCreation.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.json(config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<ImageSearchResult> searchImages(String term) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("search").queryParam("term", term);
        return this.request("GET", IMAGES_SEARCH_RESULT_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void pull(String image) throws DockerException, InterruptedException {
        this.pull(image, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path("create");
        resource = resource.queryParam("fromImage", imageRef.getImage());
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try (ProgressStream pull = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE).header("X-Registry-Auth", this.authHeader()));){
            pull.tail(handler, "POST", resource.getUri());
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void pull(String image, AuthConfig authConfig) throws DockerException, InterruptedException {
        this.pull(image, authConfig, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, AuthConfig authConfig, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path("create");
        resource = resource.queryParam("fromImage", imageRef.getImage());
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try (ProgressStream pull = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE).header("X-Registry-Auth", this.authHeader(authConfig)));){
            pull.tail(handler, "POST", resource.getUri());
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void push(String image) throws DockerException, InterruptedException {
        this.push(image, new LoggingPushHandler(image));
    }

    @Override
    public void push(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path(imageRef.getImage()).path("push");
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        try (ProgressStream push = this.request("POST", ProgressStream.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE).header("X-Registry-Auth", this.authHeader()));){
            push.tail(handler, "POST", resource.getUri());
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void tag(String image, String name) throws DockerException, InterruptedException {
        this.tag(image, name, false);
    }

    @Override
    public void tag(String image, String name, boolean force) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(name);
        WebTarget resource = this.resource().path("images").path(image).path("tag");
        resource = resource.queryParam("repo", imageRef.getImage());
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", imageRef.getTag());
        }
        if (force) {
            resource = resource.queryParam("force", true);
        }
        try {
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public String build(Path directory, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, String name, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, name, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, handler, params);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String build(Path directory, String name, ProgressHandler handler, DockerClient.BuildParameter ... params) throws DockerException, InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ImageInfo inspectImage(String image) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).path("json");
            return this.request("GET", ImageInfo.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<RemovedImage> removeImage(String image) throws DockerException, InterruptedException {
        return this.removeImage(image, false, false);
    }

    @Override
    public List<RemovedImage> removeImage(String image, boolean force, boolean noPrune) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).queryParam("force", String.valueOf(force)).queryParam("noprune", String.valueOf(noPrune));
            return this.request("DELETE", REMOVED_IMAGE_LIST, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image);
                }
            }
            throw e;
        }
    }

    @Override
    public LogStream logs(String containerId, DockerClient.LogsParameter ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("logs");
        for (DockerClient.LogsParameter param : params) {
            resource = resource.queryParam(param.name().toLowerCase(Locale.ROOT), String.valueOf(true));
        }
        try {
            return this.request("GET", LogStream.class, resource, resource.request("application/vnd.docker.raw-stream"));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    @Override
    public LogStream attachContainer(String containerId, DockerClient.AttachParameter ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("attach");
        for (DockerClient.AttachParameter param : params) {
            resource = resource.queryParam(param.name().toLowerCase(Locale.ROOT), String.valueOf(true));
        }
        try {
            return this.request("POST", LogStream.class, resource, resource.request("application/vnd.docker.raw-stream"));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    @Override
    public String execCreate(String containerId, String[] cmd, DockerClient.ExecParameter ... params) throws DockerException, InterruptedException {
        String response;
        WebTarget resource = this.resource().path("containers").path(containerId).path("exec");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator(writer);
            generator.writeStartObject();
            for (DockerClient.ExecParameter execParameter : params) {
                generator.writeBooleanField(execParameter.getName(), true);
            }
            generator.writeArrayFieldStart("Cmd");
            for (String string : cmd) {
                generator.writeString(string);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        try {
            response = this.request("POST", String.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE), Entity.json(writer.toString()));
        }
        catch (DockerRequestException dockerRequestException) {
            switch (dockerRequestException.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw dockerRequestException;
        }
        try {
            JsonNode jsonNode = ObjectMapperProvider.objectMapper().readTree(response);
            return jsonNode.findValue("Id").textValue();
        }
        catch (IOException iOException) {
            throw new DockerException(iOException);
        }
    }

    @Override
    public LogStream execStart(String execId, DockerClient.ExecStartParameter ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("exec").path(execId).path("start");
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator(writer);
            generator.writeStartObject();
            for (DockerClient.ExecStartParameter param : params) {
                generator.writeBooleanField(param.getName(), true);
            }
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        try {
            return this.request("POST", LogStream.class, resource, resource.request("application/vnd.docker.raw-stream"), Entity.json(writer.toString()));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ExecNotFoundException(execId);
                }
            }
            throw e;
        }
    }

    @Override
    public ExecState execInspect(String execId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("exec").path(execId).path("json");
        try {
            return this.request("GET", ExecState.class, resource, resource.request(MediaType.APPLICATION_JSON_TYPE));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ExecNotFoundException(execId);
                }
            }
            throw e;
        }
    }

    private WebTarget resource() {
        return this.client.target(this.uri).path(VERSION);
    }

    private WebTarget noTimeoutResource() {
        return this.noTimeoutClient.target(this.uri).path(VERSION);
    }

    private <T> T request(String method, GenericType<T> type, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, type).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, clazz).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        try {
            return request.async().method(method, entity, clazz).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            request.async().method(method, String.class).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private void request(String method, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        try {
            request.async().method(method, entity, String.class).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, e);
        }
    }

    private RuntimeException propagate(String method, WebTarget resource, Exception e) throws DockerException, InterruptedException {
        Throwable cause = e.getCause();
        if (e instanceof MultiException) {
            cause = cause.getCause();
        }
        Response response = null;
        if (cause instanceof ResponseProcessingException) {
            response = ((ResponseProcessingException)cause).getResponse();
        } else if (cause instanceof WebApplicationException) {
            response = ((WebApplicationException)cause).getResponse();
        } else if (cause instanceof ProcessingException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (response != null) {
            throw new DockerRequestException(method, resource.getUri(), response.getStatus(), this.message(response), cause);
        }
        if (cause instanceof SocketTimeoutException || cause instanceof ConnectTimeoutException) {
            throw new DockerTimeoutException(method, resource.getUri(), e);
        }
        if (cause instanceof InterruptedIOException || cause instanceof InterruptedException) {
            throw new InterruptedException("Interrupted: " + method + " " + resource);
        }
        throw new DockerException(e);
    }

    private String message(Response response) {
        InputStreamReader reader = new InputStreamReader(response.readEntity(InputStream.class), StandardCharsets.UTF_8);
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private String authHeader() throws DockerException {
        return this.authHeader(this.authConfig);
    }

    private String authHeader(AuthConfig authConfig) throws DockerException {
        if (authConfig == null) {
            return "null";
        }
        try {
            return Base64.encodeAsString(ObjectMapperProvider.objectMapper().writeValueAsString(authConfig));
        }
        catch (JsonProcessingException ex) {
            throw new DockerException("Could not encode X-Registry-Auth header", ex);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromEnv() throws DockerCertificateException {
        String endpoint = (String)Optional.fromNullable((Object)System.getenv("DOCKER_HOST")).or((Object)DefaultDockerClient.defaultEndpoint());
        String dockerCertPath = System.getenv("DOCKER_CERT_PATH");
        Builder builder = new Builder();
        if (endpoint.startsWith("unix://")) {
            builder.uri(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            HostAndPort hostAndPort = HostAndPort.fromString((String)stripped);
            String hostText = hostAndPort.getHostText();
            String scheme = Strings.isNullOrEmpty((String)dockerCertPath) ? "http" : "https";
            int port = hostAndPort.getPortOrDefault(2375);
            String address = Strings.isNullOrEmpty((String)hostText) ? DEFAULT_HOST : hostText;
            builder.uri(scheme + "://" + address + ":" + port);
        }
        if (!Strings.isNullOrEmpty((String)dockerCertPath)) {
            builder.dockerCertificates(new DockerCertificates(Paths.get(dockerCertPath, new String[0])));
        }
        return builder;
    }

    private static String defaultEndpoint() {
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            return DEFAULT_UNIX_ENDPOINT;
        }
        return "localhost:2375";
    }

    static /* synthetic */ long access$600() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    static /* synthetic */ long access$700() {
        return DEFAULT_READ_TIMEOUT_MILLIS;
    }

    public static class Builder {
        private URI uri;
        private long connectTimeoutMillis = DefaultDockerClient.access$600();
        private long readTimeoutMillis = DefaultDockerClient.access$700();
        private int connectionPoolSize = 100;
        private DockerCertificates dockerCertificates;
        private AuthConfig authConfig;

        public URI uri() {
            return this.uri;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public long connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public long readTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder readTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public DockerCertificates dockerCertificates() {
            return this.dockerCertificates;
        }

        public Builder dockerCertificates(DockerCertificates dockerCertificates) {
            this.dockerCertificates = dockerCertificates;
            return this;
        }

        public int connectionPoolSize() {
            return this.connectionPoolSize;
        }

        public Builder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public AuthConfig authConfig() {
            return this.authConfig;
        }

        public Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public DefaultDockerClient build() {
            return new DefaultDockerClient(this);
        }
    }
}

