/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.filter;

import com.spotify.docker.client.shaded.javax.annotation.Priority;
import com.spotify.docker.client.shaded.javax.ws.rs.WebApplicationException;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientRequestContext;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientRequestFilter;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientResponseContext;
import com.spotify.docker.client.shaded.javax.ws.rs.client.ClientResponseFilter;
import com.spotify.docker.client.shaded.javax.ws.rs.container.ContainerRequestContext;
import com.spotify.docker.client.shaded.javax.ws.rs.container.ContainerRequestFilter;
import com.spotify.docker.client.shaded.javax.ws.rs.container.ContainerResponseContext;
import com.spotify.docker.client.shaded.javax.ws.rs.container.ContainerResponseFilter;
import com.spotify.docker.client.shaded.javax.ws.rs.container.PreMatching;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MultivaluedMap;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.WriterInterceptor;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.WriterInterceptorContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.util.collection.StringIgnoreCaseKeyComparator;
import org.glassfish.jersey.message.MessageUtils;

@PreMatching
@Priority(value=-2147483648)
public class LoggingFilter
implements ContainerRequestFilter,
ClientRequestFilter,
ContainerResponseFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final Logger LOGGER = Logger.getLogger(LoggingFilter.class.getName());
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    private static final String ENTITY_LOGGER_PROPERTY = LoggingFilter.class.getName() + ".entityLogger";
    private static final Comparator<Map.Entry<String, List<String>>> COMPARATOR = new Comparator<Map.Entry<String, List<String>>>(){

        @Override
        public int compare(Map.Entry<String, List<String>> o1, Map.Entry<String, List<String>> o2) {
            return StringIgnoreCaseKeyComparator.SINGLETON.compare(o1.getKey(), o2.getKey());
        }
    };
    private static final int DEFAULT_MAX_ENTITY_SIZE = 8192;
    private final Logger logger;
    private final AtomicLong _id = new AtomicLong(0L);
    private final boolean printEntity;
    private final int maxEntitySize;

    public LoggingFilter() {
        this(LOGGER, false);
    }

    public LoggingFilter(Logger logger, boolean printEntity) {
        this.logger = logger;
        this.printEntity = printEntity;
        this.maxEntitySize = 8192;
    }

    public LoggingFilter(Logger logger, int maxEntitySize) {
        this.logger = logger;
        this.printEntity = true;
        this.maxEntitySize = maxEntitySize;
    }

    private void log(StringBuilder b) {
        if (this.logger != null) {
            this.logger.info(b.toString());
        }
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(Long.toString(id)).append(" ");
        return b;
    }

    private void printRequestLine(StringBuilder b, String note, long id, String method, URI uri) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(method).append(" ").append(uri.toASCIIString()).append("\n");
    }

    private void printResponseLine(StringBuilder b, String note, long id, int status) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(Integer.toString(status)).append("\n");
    }

    private void printPrefixedHeaders(StringBuilder b, long id, String prefix, MultivaluedMap<String, String> headers) {
        for (Map.Entry<String, List<String>> headerEntry : this.getSortedHeaders(headers.entrySet())) {
            List<String> val = headerEntry.getValue();
            String header = headerEntry.getKey();
            if (val.size() == 1) {
                this.prefixId(b, id).append(prefix).append(header).append(": ").append((Object)val.get(0)).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (String s : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append((Object)s);
            }
            this.prefixId(b, id).append(prefix).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    private Set<Map.Entry<String, List<String>>> getSortedHeaders(Set<Map.Entry<String, List<String>>> headers) {
        TreeSet<Map.Entry<String, List<String>>> sortedHeaders = new TreeSet<Map.Entry<String, List<String>>>(COMPARATOR);
        sortedHeaders.addAll(headers);
        return sortedHeaders;
    }

    private InputStream logInboundEntity(StringBuilder b, InputStream stream, Charset charset) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(this.maxEntitySize + 1);
        byte[] entity = new byte[this.maxEntitySize + 1];
        int entitySize = stream.read(entity);
        b.append(new String(entity, 0, Math.min(entitySize, this.maxEntitySize), charset));
        if (entitySize > this.maxEntitySize) {
            b.append("...more...");
        }
        b.append('\n');
        stream.reset();
        return stream;
    }

    @Override
    public void filter(ClientRequestContext context) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), context.getUri());
        this.printPrefixedHeaders(b, id, REQUEST_PREFIX, context.getStringHeaders());
        if (this.printEntity && context.hasEntity()) {
            LoggingStream stream = new LoggingStream(b, context.getEntityStream());
            context.setEntityStream(stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, stream);
        } else {
            this.log(b);
        }
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, RESPONSE_PREFIX, responseContext.getHeaders());
        if (this.printEntity && responseContext.hasEntity()) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), MessageUtils.getCharset(responseContext.getMediaType())));
        }
        this.log(b);
    }

    @Override
    public void filter(ContainerRequestContext context) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, REQUEST_PREFIX, context.getHeaders());
        if (this.printEntity && context.hasEntity()) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset(context.getMediaType())));
        }
        this.log(b);
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        long id = this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, RESPONSE_PREFIX, responseContext.getStringHeaders());
        if (this.printEntity && responseContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream(stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, stream);
        } else {
            this.log(b);
        }
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)writerInterceptorContext.getProperty(ENTITY_LOGGER_PROPERTY);
        writerInterceptorContext.proceed();
        if (stream != null) {
            this.log(stream.getStringBuilder(MessageUtils.getCharset(writerInterceptorContext.getMediaType())));
        }
    }

    private class LoggingStream
    extends OutputStream {
        private final StringBuilder b;
        private final OutputStream inner;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        LoggingStream(StringBuilder b, OutputStream inner) {
            this.b = b;
            this.inner = inner;
        }

        StringBuilder getStringBuilder(Charset charset) {
            byte[] entity = this.baos.toByteArray();
            this.b.append(new String(entity, 0, Math.min(entity.length, LoggingFilter.this.maxEntitySize), charset));
            if (entity.length > LoggingFilter.this.maxEntitySize) {
                this.b.append("...more...");
            }
            this.b.append('\n');
            return this.b;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.baos.size() <= LoggingFilter.this.maxEntitySize) {
                this.baos.write(i);
            }
            this.inner.write(i);
        }
    }
}

