/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.spotify.docker.client.DockerConfigReader;
import com.spotify.docker.client.messages.AutoValue_RegistryAuth;
import java.io.IOException;
import javax.annotation.Nullable;
import org.glassfish.jersey.internal.util.Base64;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RegistryAuth {
    @Nullable
    @JsonProperty(value="username")
    public abstract String username();

    @Nullable
    @JsonProperty(value="password")
    public abstract String password();

    @Nullable
    @JsonProperty(value="email")
    public abstract String email();

    @Nullable
    @JsonProperty(value="serveraddress")
    public abstract String serverAddress();

    @Nullable
    @JsonProperty(value="identitytoken")
    public abstract String identityToken();

    public final String toString() {
        return MoreObjects.toStringHelper(RegistryAuth.class).add("username", (Object)this.username()).add("serveraddress", (Object)this.serverAddress()).add("identitytoken", (Object)this.identityToken()).toString();
    }

    public abstract Builder toBuilder();

    @Deprecated
    public static Builder fromDockerConfig() throws IOException {
        return new DockerConfigReader().anyRegistryAuth().toBuilder();
    }

    public static Builder fromDockerConfig(String serverAddress) throws IOException {
        DockerConfigReader dockerCfgReader = new DockerConfigReader();
        return dockerCfgReader.authForRegistry(dockerCfgReader.defaultConfigPath(), serverAddress).toBuilder();
    }

    @JsonCreator
    public static RegistryAuth create(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="email") String email, @JsonProperty(value="serveraddress") String serveraddress, @JsonProperty(value="identitytoken") String identitytoken, @JsonProperty(value="auth") String auth) {
        Builder builder = auth != null ? RegistryAuth.forAuth(auth) : RegistryAuth.builder().username(username).password(password);
        return builder.email(email).serverAddress(serveraddress).identityToken(identitytoken).build();
    }

    public static Builder forAuth(String auth) {
        String[] authParams = Base64.decodeAsString((String)auth).split(":", 2);
        if (authParams.length != 2) {
            return RegistryAuth.builder();
        }
        return RegistryAuth.builder().username(authParams[0].trim()).password(authParams[1].trim());
    }

    public static Builder builder() {
        return new AutoValue_RegistryAuth.Builder();
    }

    public static abstract class Builder {
        public abstract Builder username(String var1);

        public abstract Builder password(String var1);

        public abstract Builder email(String var1);

        public abstract Builder serverAddress(String var1);

        public abstract Builder identityToken(String var1);

        public abstract RegistryAuth build();
    }
}

