/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.util.HashMap;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRegistryAuthSupplier
implements RegistryAuthSupplier {
    private static final Logger log = LoggerFactory.getLogger(MavenRegistryAuthSupplier.class);
    private final Settings settings;

    public MavenRegistryAuthSupplier(Settings settings) {
        this.settings = settings;
    }

    public RegistryAuth authFor(String imageName) throws DockerException {
        ImageRef ref = new ImageRef(imageName);
        Server server = this.settings.getServer(ref.getRegistryName());
        if (server != null) {
            return RegistryAuth.builder().username(server.getUsername()).password(server.getPassword()).build();
        }
        log.warn("Did not find maven server configuration for docker server " + ref.getRegistryName());
        return null;
    }

    public RegistryAuth authForSwarm() throws DockerException {
        return null;
    }

    public RegistryConfigs authForBuild() throws DockerException {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        for (Server server : this.settings.getServers()) {
            allConfigs.put(server.getId(), RegistryAuth.builder().username(server.getUsername()).password(server.getPassword()).build());
        }
        return RegistryConfigs.create(allConfigs);
    }
}

