/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.google.gson.Gson;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.plugin.dockerfile.AbstractDockerMojo;
import com.spotify.plugin.dockerfile.LoggingProgressHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class BuildMojo
extends AbstractDockerMojo {
    @Parameter(defaultValue="${project.basedir}", property="dockerfile.contextDirectory", required=true)
    private File contextDirectory;
    @Parameter(property="dockerfile.dockerfile", required=false)
    private File dockerfile;
    @Parameter(property="dockerfile.repository")
    private String repository;
    @Parameter(property="dockerfile.tag", defaultValue="latest")
    private String tag;
    @Parameter(property="dockerfile.build.skip", defaultValue="false")
    private boolean skipBuild;
    @Parameter(property="dockerfile.build.pullNewerImage", defaultValue="true")
    private boolean pullNewerImage;
    @Parameter(property="dockerfile.build.noCache", defaultValue="false")
    private boolean noCache;
    @Parameter(property="dockerfile.buildArgs")
    private Map<String, String> buildArgs;
    @Parameter(property="dockerfile.build.cacheFrom")
    private List<String> cacheFrom;
    @Parameter(property="dockerfile.build.squash", defaultValue="false")
    private boolean squash;

    @Override
    public void execute(DockerClient dockerClient) throws MojoExecutionException, MojoFailureException {
        String imageId;
        Log log = this.getLog();
        if (this.skipBuild) {
            log.info((CharSequence)"Skipping execution because 'dockerfile.build.skip' is set");
            return;
        }
        log.info((CharSequence)("dockerfile: " + this.dockerfile));
        log.info((CharSequence)("contextDirectory: " + this.contextDirectory));
        Path dockerfilePath = null;
        if (this.dockerfile != null) {
            dockerfilePath = this.dockerfile.toPath();
        }
        if ((imageId = BuildMojo.buildImage(dockerClient, log, this.verbose, this.contextDirectory.toPath(), dockerfilePath, this.repository, this.tag, this.pullNewerImage, this.noCache, this.buildArgs, this.cacheFrom, this.squash)) == null) {
            log.warn((CharSequence)"Docker build was successful, but no image was built");
        } else {
            log.info((CharSequence)MessageFormat.format("Detected build of image with id {0}", imageId));
            this.writeMetadata(AbstractDockerMojo.Metadata.IMAGE_ID, imageId);
        }
        if (this.repository != null) {
            this.writeImageInfo(this.repository, this.tag);
        }
        this.writeMetadata(log);
        if (this.repository == null) {
            log.info((CharSequence)MessageFormat.format("Successfully built {0}", imageId));
        } else {
            log.info((CharSequence)MessageFormat.format("Successfully built {0}", BuildMojo.formatImageName(this.repository, this.tag)));
        }
    }

    @Nullable
    static String buildImage(@Nonnull DockerClient dockerClient, @Nonnull Log log, boolean verbose, @Nonnull Path contextDirectory, @Nullable Path dockerfile, @Nullable String repository, @Nonnull String tag, boolean pullNewerImage, boolean noCache, @Nullable Map<String, String> buildArgs, @Nullable List<String> cacheFrom, boolean squash) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MessageFormat.format("Building Docker context {0}", contextDirectory));
        BuildMojo.requireValidDockerFilePath(log, contextDirectory, dockerfile);
        ArrayList<DockerClient.BuildParam> buildParameters = new ArrayList<DockerClient.BuildParam>();
        if (dockerfile != null) {
            buildParameters.add(DockerClient.BuildParam.dockerfile((Path)contextDirectory.relativize(dockerfile)));
        }
        LoggingProgressHandler progressHandler = new LoggingProgressHandler(log, verbose);
        if (pullNewerImage) {
            buildParameters.add(DockerClient.BuildParam.pullNewerImage());
        }
        if (noCache) {
            buildParameters.add(DockerClient.BuildParam.noCache());
        }
        if (buildArgs != null && !buildArgs.isEmpty()) {
            buildParameters.add(new DockerClient.BuildParam("buildargs", BuildMojo.encodeBuildParam(buildArgs)));
        }
        if (cacheFrom != null) {
            ArrayList<String> cacheFromExistLocally = new ArrayList<String>();
            for (String image : cacheFrom) {
                try {
                    if (pullNewerImage || !BuildMojo.imageExistLocally(dockerClient, image)) {
                        dockerClient.pull(image);
                    }
                    log.info((CharSequence)MessageFormat.format("Build will use image {0} for cache-from", image));
                    cacheFromExistLocally.add(image);
                }
                catch (ImageNotFoundException e) {
                    log.warn((CharSequence)MessageFormat.format("Image {0} not found, build will not use it for cache-from", image));
                }
                catch (DockerException | InterruptedException e) {
                    throw new MojoExecutionException("Could not pull cache-from image", (Exception)e);
                }
            }
            if (!cacheFromExistLocally.isEmpty()) {
                buildParameters.add(new DockerClient.BuildParam("cache-from", BuildMojo.encodeBuildParam(cacheFromExistLocally)));
            }
        }
        if (squash) {
            buildParameters.add(new DockerClient.BuildParam("squash", BuildMojo.encodeBuildParam(squash)));
        }
        DockerClient.BuildParam[] buildParametersArray = buildParameters.toArray(new DockerClient.BuildParam[buildParameters.size()]);
        log.info((CharSequence)"");
        try {
            if (repository != null) {
                String name = BuildMojo.formatImageName(repository, tag);
                log.info((CharSequence)MessageFormat.format("Image will be built as {0}", name));
                log.info((CharSequence)"");
                dockerClient.build(contextDirectory, name, (ProgressHandler)progressHandler, buildParametersArray);
            } else {
                log.info((CharSequence)"Image will be built without a name");
                log.info((CharSequence)"");
                dockerClient.build(contextDirectory, (ProgressHandler)progressHandler, buildParametersArray);
            }
        }
        catch (DockerException | IOException | InterruptedException e) {
            throw new MojoExecutionException("Could not build image", (Exception)e);
        }
        log.info((CharSequence)"");
        return progressHandler.builtImageId();
    }

    private static void requireValidDockerFilePath(@Nonnull Log log, @Nonnull Path contextDirectory, @Nullable Path dockerfile) throws MojoFailureException {
        log.info((CharSequence)("Path(dockerfile): " + dockerfile));
        log.info((CharSequence)("Path(contextDirectory): " + contextDirectory));
        if (dockerfile == null && !Files.exists(contextDirectory.resolve("Dockerfile"), new LinkOption[0]) && !Files.exists(contextDirectory.resolve("dockerfile"), new LinkOption[0])) {
            log.error((CharSequence)("Missing Dockerfile in context directory: " + contextDirectory));
            throw new MojoFailureException("Missing Dockerfile in context directory: " + contextDirectory);
        }
        if (dockerfile != null) {
            if (!Files.exists(dockerfile, new LinkOption[0])) {
                log.error((CharSequence)("Missing Dockerfile at " + dockerfile));
                throw new MojoFailureException("Missing Dockerfile at " + dockerfile);
            }
            if (!dockerfile.startsWith(contextDirectory)) {
                log.error((CharSequence)("Dockerfile " + dockerfile + " is not a child of the context directory: " + contextDirectory));
                throw new MojoFailureException("Dockerfile " + dockerfile + " is not a child of the context directory: " + contextDirectory);
            }
        }
    }

    private static String encodeBuildParam(Object buildParam) throws MojoExecutionException {
        try {
            return URLEncoder.encode(new Gson().toJson(buildParam), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MojoExecutionException("Could not build image", (Exception)e);
        }
    }

    private static boolean imageExistLocally(DockerClient dockerClient, String image) throws DockerException, InterruptedException {
        try {
            dockerClient.inspectImage(image);
            return true;
        }
        catch (ImageNotFoundException e) {
            return false;
        }
    }
}

