/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.ejb;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCFullyManagedComponentProvider;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBComponentProviderFactory
implements IoCComponentProviderFactory,
IoCComponentProcessorFactoryInitializer {
    private static final Logger LOGGER = Logger.getLogger(EJBComponentProviderFactory.class.getName());
    private final EJBInjectionInterceptor interceptor = new EJBInjectionInterceptor();

    public EJBComponentProviderFactory(Object interceptorBinder, Method interceptorBinderMethod) {
        try {
            interceptorBinderMethod.invoke(interceptorBinder, this.interceptor);
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
    }

    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class<?> c) {
        if (c.isAnnotationPresent(Stateless.class)) {
            try {
                InitialContext ic = new InitialContext();
                String name = this.getName(c);
                Object o = ic.lookup(name);
                LOGGER.info("Binding the EJB class " + c.getName() + " with the module name " + name + " to EJBManagedComponentProvider");
                return new EJBManagedComponentProvider(o);
            }
            catch (NamingException ne) {
                throw new EJBException((Exception)ne);
            }
        }
        return null;
    }

    public void init(IoCComponentProcessorFactory cpf) {
        this.interceptor.setFactory(cpf);
    }

    private String getName(Class<?> c) {
        Stateless s = c.getAnnotation(Stateless.class);
        String simpleName = s.name();
        if (simpleName == null || simpleName.length() == 0) {
            simpleName = c.getSimpleName();
        }
        return "java:module/" + simpleName + "!" + c.getName();
    }

    private static class EJBInjectionInterceptor {
        private IoCComponentProcessorFactory cpf;

        private EJBInjectionInterceptor() {
        }

        public void setFactory(IoCComponentProcessorFactory cpf) {
            this.cpf = cpf;
        }

        @PostConstruct
        private void init(InvocationContext context) throws Exception {
            if (this.cpf == null) {
                return;
            }
            Object beanInstance = context.getTarget();
            this.cpf.get(beanInstance.getClass(), ComponentScope.Singleton).postConstruct(beanInstance);
            context.proceed();
        }
    }

    private static class EJBManagedComponentProvider
    implements IoCFullyManagedComponentProvider {
        private final Object o;

        EJBManagedComponentProvider(Object o) {
            this.o = o;
        }

        public Object getInstance() {
            return this.o;
        }
    }
}

