/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container.servlet;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationFactory;
import com.sun.jersey.spi.container.servlet.WebComponent;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainer
extends HttpServlet
implements Filter {
    public static final String APPLICATION_CONFIG_CLASS = "javax.ws.rs.Application";
    public static final String RESOURCE_CONFIG_CLASS = "com.sun.jersey.config.property.resourceConfigClass";
    public static final String JSP_TEMPLATES_BASE_PATH = "com.sun.jersey.config.property.JSPTemplatesBasePath";
    public static final String PROPERTY_WEB_PAGE_CONTENT_REGEX = "com.sun.jersey.config.property.WebPageContentRegex";
    private transient WebComponent webComponent;
    private transient FilterConfig filterConfig;
    private transient Pattern staticContentPattern;

    public ServletContext getServletContext() {
        if (this.filterConfig != null) {
            return this.filterConfig.getServletContext();
        }
        return super.getServletContext();
    }

    protected void init(WebConfig webConfig) throws ServletException {
        this.webComponent = new InternalWebComponent();
        this.webComponent.init(webConfig);
    }

    protected WebConfig getWebConfig() {
        return this.webComponent.getWebConfig();
    }

    protected WebApplication create() {
        return WebApplicationFactory.createWebApplication();
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc) throws ServletException {
        return this.webComponent.getClassPathResourceConfig(props, wc);
    }

    protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
        if (this.getServletConfig() != null) {
            this.configure(this.getServletConfig(), rc, wa);
        } else if (this.filterConfig != null) {
            this.configure(this.filterConfig, rc, wa);
        }
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        wa.initiate(rc);
    }

    public void load() {
        this.webComponent.load();
    }

    public void reload() {
        this.webComponent.reload();
    }

    public void service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.webComponent.service(baseUri, requestUri, request, response);
    }

    public void destroy() {
        this.webComponent.destroy();
    }

    public void init() throws ServletException {
        this.init(new WebConfig(){

            @Override
            public String getName() {
                return ServletContainer.this.getServletName();
            }

            @Override
            public String getInitParameter(String name) {
                return ServletContainer.this.getInitParameter(name);
            }

            @Override
            public Enumeration getInitParameterNames() {
                return ServletContainer.this.getInitParameterNames();
            }

            @Override
            public ServletContext getServletContext() {
                return ServletContainer.this.getServletContext();
            }

            @Override
            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                return ServletContainer.this.getDefaultResourceConfig(props, ServletContainer.this.getServletConfig());
            }
        });
    }

    @Deprecated
    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, ServletConfig servletConfig) throws ServletException {
        return this.getDefaultResourceConfig(props, this.getWebConfig());
    }

    protected void configure(ServletConfig sc, ResourceConfig rc, WebApplication wa) {
        rc.getSingletons().add(new ContextInjectableProvider<ServletConfig>((Type)((Object)ServletConfig.class), sc));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encodedBasePath;
        if (request.getPathInfo() != null && request.getPathInfo().equals("/") && !request.getRequestURI().endsWith("/")) {
            response.setStatus(404);
            return;
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        String decodedBasePath = request.getPathInfo() != null ? request.getContextPath() + request.getServletPath() + "/" : request.getContextPath() + "/";
        if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent enocded");
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(queryParameters).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.init(new WebConfig(){

            @Override
            public String getName() {
                return ServletContainer.this.filterConfig.getFilterName();
            }

            @Override
            public String getInitParameter(String name) {
                return ServletContainer.this.filterConfig.getInitParameter(name);
            }

            @Override
            public Enumeration getInitParameterNames() {
                return ServletContainer.this.filterConfig.getInitParameterNames();
            }

            @Override
            public ServletContext getServletContext() {
                return ServletContainer.this.filterConfig.getServletContext();
            }

            @Override
            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                return null;
            }
        });
    }

    public Pattern getStaticContentPattern() {
        return this.staticContentPattern;
    }

    protected void configure(FilterConfig fc, ResourceConfig rc, WebApplication wa) {
        rc.getSingletons().add(new ContextInjectableProvider<FilterConfig>((Type)((Object)FilterConfig.class), fc));
        String regex = (String)rc.getProperty(PROPERTY_WEB_PAGE_CONTENT_REGEX);
        if (regex != null && regex.length() > 0) {
            try {
                this.staticContentPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                throw new ContainerException("The syntax is invalid for the regular expression, " + regex + ", associated with the initialization parameter " + PROPERTY_WEB_PAGE_CONTENT_REGEX, ex);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String servletPath = request.getServletPath();
        Pattern p = this.getStaticContentPattern();
        if (p != null && p.matcher(servletPath).matches()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        URI baseUri = absoluteUriBuilder.replacePath(request.getContextPath()).path("/").build(new Object[0]);
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(request.getQueryString()).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalWebComponent
    extends WebComponent {
        private InternalWebComponent() {
        }

        @Override
        protected WebApplication create() {
            return ServletContainer.this.create();
        }

        @Override
        protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
            super.configure(wc, rc, wa);
            ServletContainer.this.configure(wc, rc, wa);
        }

        @Override
        protected void initiate(ResourceConfig rc, WebApplication wa) {
            ServletContainer.this.initiate(rc, wa);
        }

        @Override
        protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc) throws ServletException {
            return ServletContainer.this.getDefaultResourceConfig(props, wc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        protected ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }
}

