/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.modeler.ModelerException;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.ws.processor.modeler.annotation.MemberInfo;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.ws.processor.modeler.annotation.TypeMonikerFactory;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.tools.ws.wscompile.FilerCodeWriter;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.ws.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.AccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceWrapperGenerator
extends WebServiceVisitor {
    protected Set<String> wrapperNames;
    protected Set<String> processedExceptions;
    protected JCodeModel cm;

    public WebServiceWrapperGenerator(ModelBuilder builder, AnnotationProcessorContext context) {
        super(builder, context);
    }

    @Override
    protected void processWebService(WebService webService, TypeDeclaration d) {
        this.cm = new JCodeModel();
        this.wrapperNames = new HashSet<String>();
        this.processedExceptions = new HashSet<String>();
    }

    @Override
    protected void postProcessWebService(WebService webService, InterfaceDeclaration d) {
        super.postProcessWebService(webService, d);
        this.doPostProcessWebService(webService, (TypeDeclaration)d);
    }

    @Override
    protected void postProcessWebService(WebService webService, ClassDeclaration d) {
        super.postProcessWebService(webService, d);
        this.doPostProcessWebService(webService, (TypeDeclaration)d);
    }

    protected void doPostProcessWebService(WebService webService, TypeDeclaration d) {
        if (this.cm != null) {
            File sourceDir = this.builder.getSourceDir();
            assert (sourceDir != null);
            ProcessorEnvironment env = this.builder.getProcessorEnvironment();
            try {
                FilerCodeWriter cw = new FilerCodeWriter(sourceDir, env);
                if (env.verbose()) {
                    cw = new ProgressCodeWriter((CodeWriter)cw, System.out);
                }
                this.cm.build((CodeWriter)cw);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void processMethod(MethodDeclaration method, WebMethod webMethod) {
        this.builder.log("WrapperGen - method: " + method);
        this.builder.log("method.getDeclaringType(): " + method.getDeclaringType());
        boolean generatedWrapper = false;
        if (this.wrapped && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            generatedWrapper = this.generateWrappers(method, webMethod);
        }
        boolean bl = generatedWrapper = this.generateExceptionBeans(method) || generatedWrapper;
        if (generatedWrapper) {
            this.builder.setWrapperGenerated(generatedWrapper);
        }
    }

    private boolean generateExceptionBeans(MethodDeclaration method) {
        String beanPackage = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            beanPackage = "jaxws.";
        }
        boolean beanGenerated = false;
        try {
            for (ReferenceType thrownType : method.getThrownTypes()) {
                ClassDeclaration typeDecl = ((com.sun.mirror.type.ClassType)thrownType).getDeclaration();
                if (typeDecl == null) {
                    this.builder.onError("webserviceap.could.not.find.typedecl", new Object[]{thrownType.toString(), this.context.getRound()});
                }
                boolean tmp = this.generateExceptionBean(typeDecl, beanPackage);
                beanGenerated = beanGenerated || tmp;
            }
        }
        catch (Exception e) {
            throw new ModelerException("modeler.nestedGeneratorError", e);
        }
        return beanGenerated;
    }

    private boolean duplicateName(String name) {
        for (String str : this.wrapperNames) {
            if (!str.equalsIgnoreCase(name)) continue;
            return true;
        }
        this.wrapperNames.add(name);
        return false;
    }

    private boolean generateWrappers(MethodDeclaration method, WebMethod webMethod) {
        boolean canOverwriteRequest;
        boolean isOneway = method.getAnnotation(Oneway.class) != null;
        String beanPackage = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            beanPackage = "jaxws.";
        }
        String methodName = method.getSimpleName();
        String operationName = this.builder.getOperationName(methodName);
        String reqName = operationName = webMethod != null && webMethod.operationName().length() > 0 ? webMethod.operationName() : operationName;
        String resName = operationName + "Response";
        String reqNamespace = this.typeNamespace;
        String resNamespace = this.typeNamespace;
        String requestClassName = beanPackage + StringUtils.capitalize((String)method.getSimpleName());
        RequestWrapper reqWrapper = (RequestWrapper)method.getAnnotation(RequestWrapper.class);
        if (reqWrapper != null) {
            if (reqWrapper.className().length() > 0) {
                requestClassName = reqWrapper.className();
            }
            if (reqWrapper.localName().length() > 0) {
                reqName = reqWrapper.localName();
            }
            if (reqWrapper.targetNamespace().length() > 0) {
                reqNamespace = reqWrapper.targetNamespace();
            }
        }
        this.builder.log("requestWrapper: " + requestClassName);
        if (this.duplicateName(requestClassName)) {
            this.builder.onError("webserviceap.method.request.wrapper.bean.name.not.unique", new Object[]{this.typeDecl.getQualifiedName(), method.toString()});
        }
        if (!(canOverwriteRequest = this.builder.canOverWriteClass(requestClassName))) {
            this.builder.log("Class " + requestClassName + " exists. Not overwriting.");
        }
        String responseClassName = null;
        boolean canOverwriteResponse = canOverwriteRequest;
        if (!isOneway) {
            responseClassName = beanPackage + StringUtils.capitalize((String)method.getSimpleName()) + "Response";
            ResponseWrapper resWrapper = (ResponseWrapper)method.getAnnotation(ResponseWrapper.class);
            if (resWrapper != null) {
                if (resWrapper.className().length() > 0) {
                    responseClassName = resWrapper.className();
                }
                if (resWrapper.localName().length() > 0) {
                    resName = resWrapper.localName();
                }
                if (resWrapper.targetNamespace().length() > 0) {
                    resNamespace = resWrapper.targetNamespace();
                }
            }
            if (this.duplicateName(responseClassName)) {
                this.builder.onError("webserviceap.method.respone.wrapper.bean.name.not.unique", new Object[]{this.typeDecl.getQualifiedName(), method.toString()});
            }
            if (!(canOverwriteResponse = this.builder.canOverWriteClass(requestClassName))) {
                this.builder.log("Class " + responseClassName + " exists. Not overwriting.");
            }
        }
        ArrayList<MemberInfo> reqMembers = new ArrayList<MemberInfo>();
        ArrayList<MemberInfo> resMembers = new ArrayList<MemberInfo>();
        WrapperInfo reqWrapperInfo = new WrapperInfo(requestClassName);
        reqWrapperInfo.setMembers(reqMembers);
        WrapperInfo resWrapperInfo = null;
        if (!isOneway) {
            resWrapperInfo = new WrapperInfo(responseClassName);
            resWrapperInfo.setMembers(resMembers);
        }
        this.seiContext.setReqWrapperOperation(method, reqWrapperInfo);
        if (!isOneway) {
            this.seiContext.setResWrapperOperation(method, resWrapperInfo);
        }
        try {
            if (!canOverwriteRequest && !canOverwriteResponse) {
                this.getWrapperMembers(reqWrapperInfo);
                this.getWrapperMembers(resWrapperInfo);
                return false;
            }
            JDefinedClass reqCls = null;
            if (canOverwriteRequest) {
                reqCls = this.getCMClass(requestClassName, ClassType.CLASS);
            }
            JDefinedClass resCls = null;
            if (!isOneway && canOverwriteResponse) {
                resCls = this.getCMClass(responseClassName, ClassType.CLASS);
            }
            this.writeXmlElementDeclaration(reqCls, reqName, reqNamespace);
            this.writeXmlElementDeclaration(resCls, resName, resNamespace);
            this.collectMembers(method, operationName, this.typeNamespace, reqMembers, resMembers);
            this.writeXmlTypeDeclaration(reqCls, reqName, reqNamespace, reqMembers);
            this.writeXmlTypeDeclaration(resCls, resName, resNamespace, resMembers);
            this.writeMembers(reqCls, reqMembers);
            this.writeMembers(resCls, resMembers);
        }
        catch (Exception e) {
            throw new ModelerException("modeler.nestedGeneratorError", e);
        }
        return true;
    }

    private void getWrapperMembers(WrapperInfo wrapperInfo) throws Exception {
        if (wrapperInfo == null) {
            return;
        }
        TypeDeclaration type = this.builder.getTypeDeclaration(wrapperInfo.getWrapperName());
        Collection fields = type.getFields();
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        int i = 0;
        for (FieldDeclaration field : fields) {
            XmlElement xmlElement = (XmlElement)field.getAnnotation(XmlElement.class);
            String fieldName = field.getSimpleName();
            String typeName = field.getType().toString();
            String elementName = xmlElement != null ? xmlElement.name() : fieldName;
            String namespace = xmlElement != null ? xmlElement.namespace() : "";
            String idxStr = fieldName.substring(3);
            int index = Integer.parseInt(idxStr);
            MemberInfo member = new MemberInfo(index, typeName, field.getSimpleName(), new QName(namespace, elementName));
            int j = 0;
            if (j >= members.size() || ((MemberInfo)members.get(j++)).getParamIndex() < index) {
                // empty if block
            }
            members.add(j, member);
            ++i;
        }
        for (MemberInfo member2 : members) {
            wrapperInfo.addMember(member2);
        }
    }

    private void collectMembers(MethodDeclaration method, String operationName, String namespace, ArrayList<MemberInfo> requestMembers, ArrayList<MemberInfo> responseMembers) {
        AnnotationProcessorEnvironment apEnv = this.builder.getAPEnv();
        WebResult webResult = (WebResult)method.getAnnotation(WebResult.class);
        String responseElementName = "return";
        String responseNamespace = this.wrapped ? "" : this.typeNamespace;
        boolean isResultHeader = false;
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                responseElementName = webResult.name();
            }
            responseNamespace = webResult.targetNamespace().length() > 1 ? webResult.targetNamespace() : responseNamespace;
            isResultHeader = webResult.header();
        }
        int paramIndex = -1;
        TypeMirror typeMirror = apEnv.getTypeUtils().getErasure(method.getReturnType());
        String retType = typeMirror.toString();
        if (!(method.getReturnType() instanceof VoidType) && !isResultHeader) {
            responseMembers.add(new MemberInfo(-1, retType, "_return", new QName(responseNamespace, responseElementName)));
        }
        for (ParameterDeclaration param : method.getParameters()) {
            String paramNamespace;
            WebParam.Mode mode = null;
            ++paramIndex;
            TypeMirror holderType = this.builder.getHolderValueType(param.getType());
            WebParam webParam = (WebParam)param.getAnnotation(WebParam.class);
            typeMirror = apEnv.getTypeUtils().getErasure(param.getType());
            String paramType = typeMirror.toString();
            String string = paramNamespace = this.wrapped ? "" : this.typeNamespace;
            if (holderType != null) {
                paramType = holderType.toString();
            }
            String paramName = "arg" + paramIndex;
            if (webParam != null && webParam.header()) continue;
            if (webParam != null) {
                mode = webParam.mode();
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    paramNamespace = webParam.targetNamespace();
                }
            }
            MemberInfo memInfo = new MemberInfo(paramIndex, paramType, paramName, new QName(paramNamespace, paramName));
            if (holderType != null) {
                if (mode == null || mode.equals((Object)WebParam.Mode.INOUT)) {
                    requestMembers.add(memInfo);
                }
                responseMembers.add(memInfo);
                continue;
            }
            requestMembers.add(memInfo);
        }
    }

    private JType getType(String typeName) throws IOException {
        JType type = null;
        try {
            type = this.cm.parseType(typeName);
            return type;
        }
        catch (ClassNotFoundException e) {
            type = this.cm.ref(typeName);
            return type;
        }
    }

    private void writeMembers(JDefinedClass cls, ArrayList<MemberInfo> members) throws IOException {
        if (cls == null) {
            return;
        }
        for (MemberInfo memInfo : members) {
            JType type = this.getType(memInfo.getParamType());
            JFieldVar field = cls.field(4, type, memInfo.getParamName());
            QName elementName = memInfo.getElementName();
            if (elementName == null) continue;
            if (this.soapStyle.equals(SOAPStyle.RPC) || this.wrapped) {
                JAnnotationUse xmlElementAnn = field.annotate(XmlElement.class);
                xmlElementAnn.param("name", elementName.getLocalPart());
                xmlElementAnn.param("namespace", elementName.getNamespaceURI());
                continue;
            }
            JAnnotationUse xmlValueAnnn = field.annotate(XmlValue.class);
        }
        for (MemberInfo memInfo : members) {
            this.writeMember(cls, memInfo.getParamIndex(), memInfo.getParamType(), memInfo.getParamName(), memInfo.getElementName());
        }
    }

    protected JDefinedClass getCMClass(String className, ClassType type) {
        JDefinedClass cls = null;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private boolean generateExceptionBean(ClassDeclaration thrownDecl, String beanPackage) throws IOException {
        if (this.builder.isRemoteException((TypeDeclaration)thrownDecl)) {
            return false;
        }
        AnnotationProcessorEnvironment apEnv = this.builder.getAPEnv();
        String exceptionName = ClassNameInfo.getName(thrownDecl.getQualifiedName());
        if (this.processedExceptions.contains(exceptionName)) {
            return false;
        }
        this.processedExceptions.add(exceptionName);
        String className = beanPackage + exceptionName + "Bean";
        Map<String, TypeMirror> propertyToTypeMap = TypeModeler.getExceptionProperties((TypeDeclaration)thrownDecl);
        WebFault webFault = this.isWSDLException(propertyToTypeMap, thrownDecl);
        if (webFault != null) {
            TypeMirror beanType = propertyToTypeMap.get("faultInfo");
            FaultInfo faultInfo = new FaultInfo(TypeMonikerFactory.getTypeMoniker(beanType), true);
            String namespace = webFault.targetNamespace().length() > 0 ? webFault.targetNamespace() : this.typeNamespace;
            String name = webFault.name().length() > 0 ? webFault.name() : exceptionName;
            faultInfo.setElementName(new QName(namespace, name));
            this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        JDefinedClass cls = this.getCMClass(className, ClassType.CLASS);
        FaultInfo faultInfo = new FaultInfo(className, false);
        if (this.duplicateName(className)) {
            this.builder.onError("webserviceap.method.exception.bean.name.not.unique", new Object[]{this.typeDecl.getQualifiedName(), thrownDecl.getQualifiedName()});
        }
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>();
        TreeSet<String> keys = new TreeSet<String>(propertyToTypeMap.keySet());
        for (String key : keys) {
            TypeMirror type = propertyToTypeMap.get(key);
            TypeMirror erasureType = apEnv.getTypeUtils().getErasure(type);
            MemberInfo member = new MemberInfo(-10, erasureType.toString(), key, null);
            members.add(member);
        }
        faultInfo.setMembers(members);
        boolean canOverWriteBean = this.builder.canOverWriteClass(className);
        if (!canOverWriteBean) {
            this.builder.log("Class " + className + " exists. Not overwriting.");
            this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        if (this.seiContext.getExceptionBeanName(thrownDecl.getQualifiedName()) != null) {
            return false;
        }
        JDocComment comment = cls.javadoc();
        for (String doc : GeneratorBase.getJAXWSClassComment(this.builder.getSourceVersion())) {
            comment.add((Object)doc);
        }
        this.writeXmlElementDeclaration(cls, exceptionName, this.typeNamespace);
        this.writeXmlTypeDeclaration(cls, exceptionName, this.typeNamespace, members);
        this.writeMembers(cls, members);
        this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
        return true;
    }

    protected WebFault isWSDLException(Map<String, TypeMirror> map, ClassDeclaration thrownDecl) {
        WebFault webFault = (WebFault)thrownDecl.getAnnotation(WebFault.class);
        if (map.size() != 2 || map.get("faultInfo") == null) {
            return null;
        }
        return webFault;
    }

    private void writeXmlElementDeclaration(JDefinedClass cls, String elementName, String namespaceUri) throws IOException {
        if (cls == null) {
            return;
        }
        JAnnotationUse xmlRootElementAnn = cls.annotate(XmlRootElement.class);
        xmlRootElementAnn.param("name", elementName);
        if (namespaceUri.length() > 0) {
            xmlRootElementAnn.param("namespace", namespaceUri);
        }
        JAnnotationUse xmlAccessorTypeAnn = cls.annotate(this.cm.ref(XmlAccessorType.class));
        xmlAccessorTypeAnn.param("value", (Enum)AccessType.FIELD);
    }

    private void writeXmlTypeDeclaration(JDefinedClass cls, String typeName, String namespaceUri, ArrayList<MemberInfo> members) throws IOException {
        if (cls == null) {
            return;
        }
        JAnnotationUse xmlTypeAnn = cls.annotate(this.cm.ref(XmlType.class));
        xmlTypeAnn.param("name", typeName);
        xmlTypeAnn.param("namespace", namespaceUri);
        if (members.size() > 1) {
            JAnnotationArrayMember paramArray = xmlTypeAnn.paramArray("propOrder");
            for (MemberInfo memInfo : members) {
                paramArray.param(memInfo.getParamName());
            }
        }
    }

    private void writeMember(JDefinedClass cls, int paramIndex, String paramType, String paramName, QName elementName) throws IOException {
        if (cls == null) {
            return;
        }
        String capPropName = StringUtils.capitalize((String)paramName);
        String getterPrefix = paramType.equals("boolean") || paramType.equals("java.lang.Boolean") ? "is" : "get";
        JMethod m = null;
        JDocComment methodDoc = null;
        JType propType = this.getType(paramType);
        m = cls.method(1, propType, getterPrefix + capPropName);
        methodDoc = m.javadoc();
        JCommentPart ret = methodDoc.addReturn();
        ret.add((Object)("returns " + propType.name()));
        JBlock body = m.body();
        body._return((JExpression)JExpr._this().ref(paramName));
        m = cls.method(1, (JType)this.cm.VOID, "set" + capPropName);
        JVar param = m.param(propType, paramName);
        methodDoc = m.javadoc();
        JCommentPart part = methodDoc.addParam(paramName);
        part.add((Object)("the value for the " + paramName + " property"));
        body = m.body();
        body.assign((JAssignmentTarget)JExpr._this().ref(paramName), (JExpression)param);
    }
}

