/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.CipherHelper;
import com.sun.xml.ws.security.kerb.Krb5Context;
import com.sun.xml.ws.security.kerb.MessageToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbException;

class WrapToken
extends MessageToken {
    static final int CONFOUNDER_SIZE = 8;
    static final byte[][] pads = new byte[][]{null, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}};
    private boolean readTokenFromInputStream = true;
    private InputStream is = null;
    private byte[] tokenBytes = null;
    private int tokenOffset = 0;
    private int tokenLen = 0;
    private byte[] dataBytes = null;
    private int dataOffset = 0;
    private int dataLen = 0;
    private int dataSize = 0;
    byte[] confounder = null;
    byte[] padding = null;
    private boolean privacy = false;

    public WrapToken(Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        super(513, context, tokenBytes, tokenOffset, tokenLen, prop);
        this.readTokenFromInputStream = false;
        this.tokenBytes = tokenBytes;
        this.tokenOffset = tokenOffset;
        this.tokenLen = tokenLen;
        this.privacy = prop.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - this.getKrb5TokenSize();
    }

    public WrapToken(Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        super(513, context, is, prop);
        this.is = is;
        this.privacy = prop.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - this.getTokenSize();
    }

    public byte[] getData() throws GSSException {
        byte[] temp = new byte[this.dataSize];
        this.getData(temp, 0);
        byte[] retVal = new byte[this.dataSize - this.confounder.length - this.padding.length];
        System.arraycopy(temp, 0, retVal, 0, retVal.length);
        return retVal;
    }

    public int getData(byte[] dataBuf, int dataBufOffset) throws GSSException {
        if (this.readTokenFromInputStream) {
            this.getDataFromStream(dataBuf, dataBufOffset);
        } else {
            this.getDataFromBuffer(dataBuf, dataBufOffset);
        }
        return this.dataSize - this.confounder.length - this.padding.length;
    }

    private void getDataFromBuffer(byte[] dataBuf, int dataBufOffset) throws GSSException {
        GSSHeader gssHeader = this.getGSSHeader();
        int dataPos = this.tokenOffset + gssHeader.getLength() + this.getTokenSize();
        if (dataPos + this.dataSize > this.tokenOffset + this.tokenLen) {
            throw new GSSException(10, -1, "Insufficient data in " + WrapToken.getTokenName(this.getTokenId()));
        }
        this.confounder = new byte[8];
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenBytes, dataPos, this.dataSize, dataBuf, dataBufOffset);
        } else {
            System.arraycopy(this.tokenBytes, dataPos, this.confounder, 0, 8);
            int padSize = this.tokenBytes[dataPos + this.dataSize - 1];
            if (padSize < 0) {
                padSize = 0;
            }
            if (padSize > 8) {
                padSize %= 8;
            }
            this.padding = pads[padSize];
            System.arraycopy(this.tokenBytes, dataPos + 8, dataBuf, dataBufOffset, this.dataSize - 8 - padSize);
        }
        if (!this.verifySignAndSeqNumber(this.confounder, dataBuf, dataBufOffset, this.dataSize - 8 - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private void getDataFromStream(byte[] dataBuf, int dataBufOffset) throws GSSException {
        GSSHeader gssHeader = this.getGSSHeader();
        this.confounder = new byte[8];
        try {
            if (this.privacy) {
                this.cipherHelper.decryptData(this, this.is, this.dataSize, dataBuf, dataBufOffset);
            } else {
                WrapToken.readFully(this.is, this.confounder);
                int numBlocks = (this.dataSize - 8) / 8 - 1;
                int offset = dataBufOffset;
                for (int i = 0; i < numBlocks; ++i) {
                    WrapToken.readFully(this.is, dataBuf, offset, 8);
                    offset += 8;
                }
                byte[] finalBlock = new byte[8];
                WrapToken.readFully(this.is, finalBlock);
                byte padSize = finalBlock[7];
                this.padding = pads[padSize];
                System.arraycopy(finalBlock, 0, dataBuf, offset, finalBlock.length - padSize);
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, WrapToken.getTokenName(this.getTokenId()) + ": " + e.getMessage());
        }
        if (!this.verifySignAndSeqNumber(this.confounder, dataBuf, dataBufOffset, this.dataSize - 8 - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private byte[] getPadding(int len) {
        int padSize = 0;
        if (this.cipherHelper.isArcFour()) {
            padSize = 1;
        } else {
            padSize = len % 8;
            padSize = 8 - padSize;
        }
        return pads[padSize];
    }

    public WrapToken(Krb5Context context, MessageProp prop, byte[] dataBytes, int dataOffset, int dataLen) throws GSSException {
        super(513, context);
        try {
            new Confounder();
            this.confounder = Confounder.bytes(8);
        }
        catch (KrbException e) {
            throw new GSSException(11, -1, e.getMessage());
        }
        this.padding = this.getPadding(dataLen);
        this.dataSize = this.confounder.length + dataLen + this.padding.length;
        this.dataBytes = dataBytes;
        this.dataOffset = dataOffset;
        this.dataLen = dataLen;
        this.genSignAndSeqNumber(prop, this.confounder, dataBytes, dataOffset, dataLen, this.padding);
        if (!context.getConfState()) {
            prop.setPrivacy(false);
        }
        this.privacy = prop.getPrivacy();
    }

    public void encode(OutputStream os) throws IOException, GSSException {
        super.encode(os);
        if (!this.privacy) {
            os.write(this.confounder);
            os.write(this.dataBytes, this.dataOffset, this.dataLen);
            os.write(this.padding);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.dataBytes, this.dataOffset, this.dataLen, this.padding, os);
        }
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.dataSize + 50);
        this.encode(bos);
        return bos.toByteArray();
    }

    public int encode(byte[] outToken, int offset) throws IOException, GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        super.encode(bos);
        byte[] header = bos.toByteArray();
        System.arraycopy(header, 0, outToken, offset, header.length);
        offset += header.length;
        if (!this.privacy) {
            System.arraycopy(this.confounder, 0, outToken, offset, this.confounder.length);
            System.arraycopy(this.dataBytes, this.dataOffset, outToken, offset += this.confounder.length, this.dataLen);
            System.arraycopy(this.padding, 0, outToken, offset += this.dataLen, this.padding.length);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.dataBytes, this.dataOffset, this.dataLen, this.padding, outToken, offset);
        }
        return header.length + this.confounder.length + this.dataLen + this.padding.length;
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize() + this.dataSize;
    }

    protected int getSealAlg(boolean conf, int qop) throws GSSException {
        if (!conf) {
            return 65535;
        }
        return this.cipherHelper.getSealAlg();
    }

    static int getSizeLimit(int qop, boolean confReq, int maxTokenSize, CipherHelper ch) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, maxTokenSize) - (WrapToken.getTokenSize(ch) + 8) - 8;
    }
}

