/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.dsig.SignedMessageHeader;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.StAXAttr;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class EncryptedSignedMessageHeader
extends SignedMessageHeader {
    private SecurityHeaderElement encHeader = null;
    private boolean parsed = false;
    private String localName;
    private String uri;
    private String prefix;
    private Vector attrList = new Vector();
    private Vector attrNSList = new Vector();
    private MutableXMLStreamBuffer buffer = null;

    public EncryptedSignedMessageHeader(SignedMessageHeader hdr, SecurityHeaderElement she) {
        super(hdr);
        this.encHeader = she;
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        if (this.buffer == null) {
            this.buffer = new MutableXMLStreamBuffer();
            XMLStreamWriter writer = this.buffer.createFromXMLStreamWriter();
            super.writeTo(writer);
        }
        return this.buffer.readAsXMLStreamReader();
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (!this.parsed) {
            this.parse();
        }
        this.writeStartElement(streamWriter);
        ((SecurityElementWriter)((Object)this.encHeader)).writeTo(streamWriter);
        this.writeEndElement(streamWriter);
    }

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        if (!this.parsed) {
            this.parse();
        }
        this.writeStartElement(streamWriter);
        ((SecurityElementWriter)((Object)this.encHeader)).writeTo(streamWriter, props);
        this.writeEndElement(streamWriter);
    }

    protected void parse() throws XMLStreamException {
        XMLStreamReader reader = this.readHeader();
        this.parsed = true;
        boolean stop = false;
        while (reader.hasNext()) {
            int eventType = reader.next();
            if (stop) {
                return;
            }
            switch (eventType) {
                case 1: {
                    String uri;
                    int i;
                    this.localName = reader.getLocalName();
                    this.uri = reader.getNamespaceURI();
                    this.prefix = reader.getPrefix();
                    if (this.prefix == null) {
                        this.prefix = "";
                    }
                    int count = reader.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        String localName = reader.getAttributeLocalName(i);
                        uri = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        if (prefix == null) {
                            prefix = "";
                        }
                        String value = reader.getAttributeValue(i);
                        StAXAttr attr = new StAXAttr();
                        attr.setLocalName(localName);
                        attr.setValue(value);
                        attr.setPrefix(prefix);
                        attr.setUri(uri);
                        this.attrList.add(attr);
                    }
                    count = 0;
                    count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        if (prefix == null) {
                            prefix = "";
                        }
                        uri = reader.getNamespaceURI(i);
                        AttributeNS attrNS = new AttributeNS();
                        attrNS.setPrefix(prefix);
                        attrNS.setUri(uri);
                        this.attrNSList.add(attrNS);
                    }
                    stop = true;
                    break;
                }
                case 2: {
                    stop = true;
                }
            }
        }
    }

    private void writeEndElement(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
    }

    private void writeStartElement(XMLStreamWriter xsw) throws XMLStreamException {
        int i;
        xsw.writeStartElement(this.prefix, this.localName, this.uri);
        for (i = 0; i < this.attrNSList.size(); ++i) {
            AttributeNS attrNs = (AttributeNS)this.attrNSList.get(i);
            xsw.writeNamespace(attrNs.getPrefix(), attrNs.getUri());
        }
        for (i = 0; i < this.attrList.size(); ++i) {
            StAXAttr attr = (StAXAttr)this.attrList.get(i);
            xsw.writeAttribute(attr.getPrefix(), attr.getUri(), attr.getLocalName(), attr.getValue());
        }
    }
}

