/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl.client;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.provider.wsit.WSITClientAuthContext;
import java.util.Set;

public class DefaultSCTokenConfiguration
extends SCTokenConfiguration {
    private Trust10 trust10 = null;
    private Trust13 trust13 = null;
    private SymmetricBinding symBinding = null;
    private int skl = 0;
    private boolean reqClientEntropy = true;
    private boolean isExpired = false;
    private boolean checkTokenExpiry = true;
    private WSDLPort wsdlPort = null;
    private WSBinding wsBinding = null;
    private Pipe clientSecurityPipe = null;
    private Packet packet = null;
    private WSITClientAuthContext wsitClientAuthContext = null;
    private AddressingVersion addVer = null;
    private Token scToken = null;
    private String tokenId = null;
    private MessagePolicy messagePolicy = null;
    private boolean addRenewPolicy = true;

    public DefaultSCTokenConfiguration(String protocol, SecureConversationToken scToken, WSDLPort wsdlPort, WSBinding binding, Pipe securityPipe, Packet packet, AddressingVersion addVer) {
        this.protocol = protocol;
        this.scToken = scToken;
        this.wsdlPort = wsdlPort;
        this.wsBinding = binding;
        this.clientSecurityPipe = securityPipe;
        this.packet = packet;
        this.addVer = addVer;
        this.parseAssertions(scToken);
    }

    public DefaultSCTokenConfiguration(String protocol, SecureConversationToken scToken, WSDLPort wsdlPort, WSBinding binding, WSITClientAuthContext wsitClientAuthContext, Packet packet, AddressingVersion addVer) {
        this.protocol = protocol;
        this.scToken = scToken;
        this.wsdlPort = wsdlPort;
        this.wsBinding = binding;
        this.wsitClientAuthContext = wsitClientAuthContext;
        this.packet = packet;
        this.addVer = addVer;
        this.parseAssertions(scToken);
    }

    public DefaultSCTokenConfiguration(String protocol, String tokenId, boolean checkTokenExpiry) {
        super(protocol);
        this.tokenId = tokenId;
        this.checkTokenExpiry = checkTokenExpiry;
    }

    public DefaultSCTokenConfiguration(String protocol, MessagePolicy messagePolicy) {
        super(protocol);
        this.messagePolicy = messagePolicy;
    }

    public DefaultSCTokenConfiguration(String protocol, MessagePolicy messagePolicy, boolean addRenewPolicy) {
        this(protocol, messagePolicy);
        this.addRenewPolicy = addRenewPolicy;
    }

    public DefaultSCTokenConfiguration(String protocol, String tokenId, boolean isExpired, boolean checkTokenExpiry) {
        super(protocol);
        this.tokenId = tokenId;
        this.isExpired = isExpired;
        this.checkTokenExpiry = checkTokenExpiry;
    }

    private void parseAssertions(SecureConversationToken scToken) {
        Set trustReqdProps;
        AssertionSet assertions = scToken.getBootstrapPolicy().getAssertionSet();
        for (PolicyAssertion policyAssertion : assertions) {
            SecurityPolicyVersion spVersion;
            if (PolicyUtil.isTrust13((PolicyAssertion)policyAssertion, (SecurityPolicyVersion)(spVersion = PolicyUtil.getSecurityPolicyVersion((String)policyAssertion.getName().getNamespaceURI())))) {
                this.trust13 = (Trust13)policyAssertion;
                continue;
            }
            if (PolicyUtil.isTrust10((PolicyAssertion)policyAssertion, (SecurityPolicyVersion)spVersion)) {
                this.trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding((PolicyAssertion)policyAssertion, (SecurityPolicyVersion)spVersion)) continue;
            this.symBinding = (SymmetricBinding)policyAssertion;
        }
        if (this.symBinding != null) {
            AlgorithmSuite algoSuite = this.symBinding.getAlgorithmSuite();
            this.skl = algoSuite.getMinSKLAlgorithm();
        }
        if (this.trust10 != null) {
            trustReqdProps = this.trust10.getRequiredProperties();
            this.reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
        if (this.trust13 != null) {
            trustReqdProps = this.trust13.getRequiredProperties();
            this.reqClientEntropy = trustReqdProps.contains("RequireClientEntropy");
        }
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public boolean checkTokenExpiry() {
        return this.checkTokenExpiry;
    }

    public MessagePolicy getMessagePolicy() {
        return this.messagePolicy;
    }

    public boolean addRenewPolicy() {
        return this.addRenewPolicy;
    }

    public boolean getReqClientEntropy() {
        return this.reqClientEntropy;
    }

    public boolean isSymmetricBinding() {
        return this.symBinding != null;
    }

    public int getKeySize() {
        return this.skl;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public Token getSCToken() {
        return this.scToken;
    }

    public WSDLPort getWSDLPort() {
        return this.wsdlPort;
    }

    public WSBinding getWSBinding() {
        return this.wsBinding;
    }

    public Pipe getClientPipe() {
        return this.clientSecurityPipe;
    }

    public WSITClientAuthContext getWSITClientAuthContext() {
        return this.wsitClientAuthContext;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addVer;
    }
}

