/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigestCertSelector
implements CertSelector {
    private final byte[] keyId;
    private final String algorithm;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public DigestCertSelector(byte[] keyIdValue, String algo) {
        this.keyId = keyIdValue;
        this.algorithm = algo;
    }

    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
            byte[] thumbPrintIdentifier = null;
            try {
                thumbPrintIdentifier = MessageDigest.getInstance(this.algorithm).digest(cert.getEncoded());
            }
            catch (NoSuchAlgorithmException ex) {
                log.log(Level.SEVERE, "WSS0708.no.digest.algorithm");
                throw new RuntimeException("Digest algorithm SHA-1 not found");
            }
            catch (CertificateEncodingException ex) {
                log.log(Level.SEVERE, "WSS0709.error.getting.rawContent");
                throw new RuntimeException("Error while getting certificate's raw content");
            }
            if (Arrays.equals(thumbPrintIdentifier, this.keyId)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new DigestCertSelector(this.keyId, this.algorithm);
    }
}

