/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.StandardCode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tairanchina.csp.dew.core.DewConfig;
import com.tairanchina.csp.dew.core.DewContext;
import com.tairanchina.csp.dew.core.auth.AuthAdapter;
import com.tairanchina.csp.dew.core.auth.BasicAuthAdapter;
import com.tairanchina.csp.dew.core.basic.fun.VoidExecutor;
import com.tairanchina.csp.dew.core.basic.fun.VoidPredicate;
import com.tairanchina.csp.dew.core.basic.loading.DewLoadImmediately;
import com.tairanchina.csp.dew.core.basic.utils.NetUtils;
import com.tairanchina.csp.dew.core.cluster.Cluster;
import com.tairanchina.csp.dew.core.cluster.ClusterCache;
import com.tairanchina.csp.dew.core.cluster.ClusterElectionWrap;
import com.tairanchina.csp.dew.core.cluster.ClusterLockWrap;
import com.tairanchina.csp.dew.core.cluster.ClusterMQ;
import com.tairanchina.csp.dew.core.cluster.ClusterMapWrap;
import com.tairanchina.csp.dew.core.jdbc.DS;
import com.tairanchina.csp.dew.core.jdbc.DSManager;
import com.tairanchina.csp.dew.core.notify.Notify;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={DewConfig.class})
@Configuration
public class Dew {
    private static final Logger logger = LoggerFactory.getLogger(Dew.class);
    public static Cluster cluster = new Cluster();
    public static Notify notify = null;
    public static ApplicationContext applicationContext;
    public static DewConfig dewConfig;
    public static AuthAdapter auth;
    @Value(value="${spring.application.name:please-setting-this}")
    private String applicationName;
    @Value(value="${spring.profiles.active:default}")
    private String profile;
    @Value(value="${server.port:-1}")
    private int serverPort;
    @Autowired
    private DewConfig injectDewConfig;
    @Autowired
    private ApplicationContext injectApplicationContext;
    @Autowired(required=false)
    private JacksonProperties jacksonProperties;

    @PostConstruct
    public void init() throws IOException, ClassNotFoundException {
        logger.info("Load Auto Configuration : {}", (Object)this.getClass().getName());
        logger.info("Load Dew basic info...");
        dewConfig = this.injectDewConfig;
        applicationContext = this.injectApplicationContext;
        Info.name = this.applicationName;
        Info.profile = this.profile;
        Info.webPort = this.serverPort;
        Info.instance = this.applicationName + "@" + Info.profile + "@" + Info.ip + ":" + this.serverPort;
        Cluster.init((String)Info.name, (String)Info.instance);
        notify = new Notify();
        if (this.jacksonProperties != null) {
            this.jacksonProperties.getSerialization().put(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
        auth = (AuthAdapter)applicationContext.getBean(BasicAuthAdapter.class);
        logger.info("Use Auth Adapter:" + auth.getClass().getName());
        logger.info("Load Dew cluster...");
        if (applicationContext.containsBean(this.injectDewConfig.getCluster().getCache() + "ClusterCache")) {
            Dew.cluster.cache = (ClusterCache)applicationContext.getBean(this.injectDewConfig.getCluster().getCache() + "ClusterCache");
        }
        if (applicationContext.containsBean(this.injectDewConfig.getCluster().getLock() + "ClusterLock")) {
            Dew.cluster.lock = (ClusterLockWrap)applicationContext.getBean(this.injectDewConfig.getCluster().getLock() + "ClusterLock");
        }
        if (applicationContext.containsBean(this.injectDewConfig.getCluster().getMap() + "ClusterMap")) {
            Dew.cluster.map = (ClusterMapWrap)applicationContext.getBean(this.injectDewConfig.getCluster().getMap() + "ClusterMap");
        }
        if (applicationContext.containsBean(this.injectDewConfig.getCluster().getMq() + "ClusterMQ")) {
            Dew.cluster.mq = (ClusterMQ)applicationContext.getBean(this.injectDewConfig.getCluster().getMq() + "ClusterMQ");
        }
        if (applicationContext.containsBean(this.injectDewConfig.getCluster().getElection() + "ClusterElection")) {
            Dew.cluster.election = (ClusterElectionWrap)applicationContext.getBean(this.injectDewConfig.getCluster().getElection() + "ClusterElection");
        }
        if (dewConfig.getCluster().getConfig().isHaEnabled()) {
            Cluster.ha();
        }
        if (applicationContext.containsBean(DSManager.class.getSimpleName())) {
            applicationContext.getBean(DSManager.class);
        }
        logger.info("Load Dew funs...");
        Set loadOrders = $.clazz.scan(Dew.class.getPackage().getName(), (Set)new HashSet<Class<? extends Annotation>>(){
            {
                this.add(DewLoadImmediately.class);
            }
        }, null);
        loadOrders.forEach(loadOrder -> applicationContext.getBean(loadOrder));
    }

    public static DS ds() {
        return DSManager.select("");
    }

    public static DS ds(String dsName) {
        return DSManager.select(dsName);
    }

    public static DewContext context() {
        return DewContext.getContext();
    }

    public static class E {
        public static <E extends Throwable> E e(String code, E ex) {
            return E.e(code, ex, -1);
        }

        public static <E extends Throwable> E e(String code, E ex, StandardCode customHttpCode) {
            return E.e(code, ex, Integer.valueOf(customHttpCode.toString()));
        }

        public static <E extends Throwable> E e(String code, E ex, int customHttpCode) {
            try {
                $.bean.setValue(ex, "detailMessage", (Object)$.json.createObjectNode().put("code", code).put("message", ex.getLocalizedMessage()).put("customHttpCode", customHttpCode).toString());
            }
            catch (NoSuchFieldException e1) {
                logger.error("Throw Exception Convert error", (Throwable)e1);
            }
            return ex;
        }

        public static <E extends RuntimeException> void checkNotNull(Object obj, E ex) {
            E.check(() -> obj == null, ex);
        }

        public static <E extends RuntimeException> void checkNotEmpty(Iterable<?> objects, E ex) {
            E.check(() -> objects == null || !objects.iterator().hasNext(), ex);
        }

        public static <E extends RuntimeException> void checkNotEmpty(Map<?, ?> objects, E ex) {
            E.check(() -> objects == null || objects.size() == 0, ex);
        }

        public static <E extends RuntimeException> void check(boolean notExpected, E ex) {
            E.check(() -> notExpected, ex);
        }

        public static <E extends RuntimeException> void check(VoidPredicate notExpected, E ex) {
            if (notExpected.test()) {
                throw ex;
            }
        }

        public static void check(boolean notExpected) {
            E.check(() -> notExpected);
        }

        public static void check(VoidPredicate notExpected) {
            if (notExpected.test()) {
                throw new AssertionError((Object)"Checked error.");
            }
        }
    }

    public static class Util {
        private static ExecutorService executorService = Executors.newCachedThreadPool();

        public static String getRealIP(HttpServletRequest request) {
            HashMap<String, String> requestHeader = new HashMap<String, String>();
            Enumeration header = request.getHeaderNames();
            while (header.hasMoreElements()) {
                String key = (String)header.nextElement();
                requestHeader.put(key, request.getHeader(key));
            }
            return Util.getRealIP(requestHeader, request.getRemoteAddr());
        }

        public static String getRealIP(Map<String, String> requestHeader, String remoteAddr) {
            requestHeader.forEach((k, v) -> requestHeader.put(k.toLowerCase(), (String)v));
            if (requestHeader.containsKey("x-forwarded-for") && requestHeader.get("x-forwarded-for") != null && !requestHeader.get("x-forwarded-for").isEmpty()) {
                return requestHeader.get("x-forwarded-for");
            }
            if (requestHeader.containsKey("wl-proxy-client-ip") && requestHeader.get("wl-proxy-client-ip") != null && !requestHeader.get("wl-proxy-client-ip").isEmpty()) {
                return requestHeader.get("wl-proxy-client-ip");
            }
            if (requestHeader.containsKey("x-forwarded-host") && requestHeader.get("x-forwarded-host") != null && !requestHeader.get("x-forwarded-host").isEmpty()) {
                return requestHeader.get("x-forwarded-host");
            }
            return remoteAddr;
        }

        public static void newThread(Runnable fun) {
            executorService.execute(fun);
        }

        public static class RunnableWithContext
        implements Runnable {
            private VoidExecutor fun;
            private DewContext context;

            public RunnableWithContext(VoidExecutor fun) {
                this.fun = fun;
                this.context = DewContext.getContext();
            }

            @Override
            public void run() {
                DewContext.setContext(this.context);
                this.fun.exec();
            }
        }
    }

    public static class Timer {
        private static final Logger logger = LoggerFactory.getLogger(Timer.class);

        public static void periodic(long initialDelaySec, long periodSec, VoidExecutor fun) {
            DewContext context = Dew.context();
            $.timer.periodic(initialDelaySec, periodSec, true, () -> {
                DewContext.setContext(context);
                try {
                    fun.exec();
                }
                catch (Exception e) {
                    logger.error("[Timer] Execute error", (Throwable)e);
                }
            });
        }

        public static void periodic(long periodSec, VoidExecutor fun) {
            Timer.periodic(0L, periodSec, fun);
        }

        public static void timer(long delaySec, VoidExecutor fun) {
            DewContext context = Dew.context();
            $.timer.timer(delaySec, () -> {
                DewContext.setContext(context);
                try {
                    fun.exec();
                }
                catch (Exception e) {
                    logger.error("[Timer] Execute error", (Throwable)e);
                }
            });
        }
    }

    public static class Info {
        public static String name;
        public static String profile;
        public static String ip;
        public static String host;
        public static int webPort;
        public static String instance;

        static {
            InetAddress inetAddress = NetUtils.getLocalAddress();
            ip = inetAddress.getHostAddress();
            host = inetAddress.getHostName();
        }
    }

    public static class Constant {
        public static final String HTTP_REQUEST_FROM_FLAG = "Request-From";
    }
}

