/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="dew")
public class DewConfig {
    private Basic basic = new Basic();
    private Cluster cluster = new Cluster();
    private Security security = new Security();
    private Metric metric = new Metric();
    private Map<String, Notify> notifies = new HashMap<String, Notify>();

    public Basic getBasic() {
        return this.basic;
    }

    public void setBasic(Basic basic) {
        this.basic = basic;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Map<String, Notify> getNotifies() {
        return this.notifies;
    }

    public void setNotifies(Map<String, Notify> notifies) {
        this.notifies = notifies;
    }

    public static class Notify {
        private String type = "DD";
        private Set<String> defaultReceivers = new HashSet<String>();
        private Set<String> dndTimeReceivers = new HashSet<String>();
        private Map<String, Object> args = new HashMap<String, Object>();
        private Strategy strategy = new Strategy();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Set<String> getDefaultReceivers() {
            return this.defaultReceivers;
        }

        public void setDefaultReceivers(Set<String> defaultReceivers) {
            this.defaultReceivers = defaultReceivers;
        }

        public Set<String> getDndTimeReceivers() {
            return this.dndTimeReceivers;
        }

        public void setDndTimeReceivers(Set<String> dndTimeReceivers) {
            this.dndTimeReceivers = dndTimeReceivers;
        }

        public Map<String, Object> getArgs() {
            return this.args;
        }

        public void setArgs(Map<String, Object> args) {
            this.args = args;
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public static class Strategy {
            private int minIntervalSec = 0;
            private String dndTime = "";
            private int forceSendTimes = 3;

            public int getMinIntervalSec() {
                return this.minIntervalSec;
            }

            public void setMinIntervalSec(int minIntervalSec) {
                this.minIntervalSec = minIntervalSec;
            }

            public String getDndTime() {
                return this.dndTime;
            }

            public void setDndTime(String dndTime) {
                this.dndTime = dndTime;
            }

            public int getForceSendTimes() {
                return this.forceSendTimes;
            }

            public void setForceSendTimes(int forceSendTimes) {
                this.forceSendTimes = forceSendTimes;
            }
        }
    }

    public static class Metric {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Security {
        private SecurityCORS cors = new SecurityCORS();
        private String tokenFlag = "__dew_token__";
        private boolean tokenInHeader = true;
        private boolean tokenHash = false;
        private List<String> includeServices;
        private List<String> excludeServices;

        public List<String> getIncludeServices() {
            return this.includeServices;
        }

        public void setIncludeServices(List<String> includeServices) {
            this.includeServices = includeServices;
        }

        public List<String> getExcludeServices() {
            return this.excludeServices;
        }

        public void setExcludeServices(List<String> excludeServices) {
            this.excludeServices = excludeServices;
        }

        public SecurityCORS getCors() {
            return this.cors;
        }

        public void setCors(SecurityCORS cors) {
            this.cors = cors;
        }

        public String getTokenFlag() {
            return this.tokenFlag;
        }

        public void setTokenFlag(String tokenFlag) {
            this.tokenFlag = tokenFlag;
        }

        public boolean isTokenInHeader() {
            return this.tokenInHeader;
        }

        public void setTokenInHeader(boolean tokenInHeader) {
            this.tokenInHeader = tokenInHeader;
        }

        public boolean isTokenHash() {
            return this.tokenHash;
        }

        public void setTokenHash(boolean tokenHash) {
            this.tokenHash = tokenHash;
        }

        public static class SecurityCORS {
            private String allowOrigin = "*";
            private String allowMethods = "POST,GET,OPTIONS,PUT,DELETE,HEAD";
            private String allowHeaders = "x-requested-with,content-type";

            public String getAllowOrigin() {
                return this.allowOrigin;
            }

            public void setAllowOrigin(String allowOrigin) {
                this.allowOrigin = allowOrigin;
            }

            public String getAllowMethods() {
                return this.allowMethods;
            }

            public void setAllowMethods(String allowMethods) {
                this.allowMethods = allowMethods;
            }

            public String getAllowHeaders() {
                return this.allowHeaders;
            }

            public void setAllowHeaders(String allowHeaders) {
                this.allowHeaders = allowHeaders;
            }
        }
    }

    public static class Cluster {
        private String mq = "redis";
        private String cache = "redis";
        private String lock = "redis";
        private String map = "redis";
        private String election = "redis";
        private Config config = new Config();

        public String getMq() {
            return this.mq;
        }

        public void setMq(String mq) {
            this.mq = mq;
        }

        public String getCache() {
            return this.cache;
        }

        public void setCache(String cache) {
            this.cache = cache;
        }

        public String getLock() {
            return this.lock;
        }

        public void setLock(String lock) {
            this.lock = lock;
        }

        public String getMap() {
            return this.map;
        }

        public void setMap(String map) {
            this.map = map;
        }

        public String getElection() {
            return this.election;
        }

        public void setElection(String election) {
            this.election = election;
        }

        public Config getConfig() {
            return this.config;
        }

        public void setConfig(Config config) {
            this.config = config;
        }

        public static class Config {
            private int electionPeriodSec = 60;
            private boolean haEnabled = true;

            public int getElectionPeriodSec() {
                return this.electionPeriodSec;
            }

            public void setElectionPeriodSec(int electionPeriodSec) {
                this.electionPeriodSec = electionPeriodSec;
            }

            public boolean isHaEnabled() {
                return this.haEnabled;
            }

            public void setHaEnabled(boolean haEnabled) {
                this.haEnabled = haEnabled;
            }
        }
    }

    public static class Basic {
        private String name = "";
        private String version = "1.0";
        private String desc = "";
        private String webSite = "";
        private Doc doc = new Doc();
        private Format format = new Format();
        private Map<String, ErrorMapping> errorMapping = new HashMap<String, ErrorMapping>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getWebSite() {
            return this.webSite;
        }

        public void setWebSite(String webSite) {
            this.webSite = webSite;
        }

        public Doc getDoc() {
            return this.doc;
        }

        public void setDoc(Doc doc) {
            this.doc = doc;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setFormat(Format format) {
            this.format = format;
        }

        public Map<String, ErrorMapping> getErrorMapping() {
            return this.errorMapping;
        }

        public void setErrorMapping(Map<String, ErrorMapping> errorMapping) {
            this.errorMapping = errorMapping;
        }

        public static class ErrorMapping {
            private int httpCode;
            private String businessCode;
            private String message;

            public int getHttpCode() {
                return this.httpCode;
            }

            public void setHttpCode(int httpCode) {
                this.httpCode = httpCode;
            }

            public String getBusinessCode() {
                return this.businessCode;
            }

            public void setBusinessCode(String businessCode) {
                this.businessCode = businessCode;
            }

            public String getMessage() {
                return this.message;
            }

            public void setMessage(String message) {
                this.message = message;
            }
        }

        public static class Format {
            private boolean useUnityError = true;
            private String errorFlag = "__DEW_ERROR__";

            public String getErrorFlag() {
                return this.errorFlag;
            }

            public void setErrorFlag(String errorFlag) {
                this.errorFlag = errorFlag;
            }

            public boolean isUseUnityError() {
                return this.useUnityError;
            }

            public void setUseUnityError(boolean useUnityError) {
                this.useUnityError = useUnityError;
            }
        }

        public static class Doc {
            private boolean enabled = true;
            private Contact contact = null;
            private String basePackage = "";

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getBasePackage() {
                return this.basePackage;
            }

            public void setBasePackage(String basePackage) {
                this.basePackage = basePackage;
            }

            public Contact getContact() {
                return this.contact;
            }

            public void setContact(Contact contact) {
                this.contact = contact;
            }

            public static class Contact {
                private String name;
                private String url;
                private String email;

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public String getUrl() {
                    return this.url;
                }

                public void setUrl(String url) {
                    this.url = url;
                }

                public String getEmail() {
                    return this.email;
                }

                public void setEmail(String email) {
                    this.email = email;
                }
            }
        }
    }
}

