/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.basic.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String ANYHOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static InetAddress getLocalAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieving ip address, " + e.getMessage(), (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtils.isValidAddress(address)) continue;
                                return address;
                            }
                            catch (Exception e) {
                                logger.warn("Failed to retrieving ip address, " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Failed to retrieving ip address, " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieving ip address, " + e.getMessage(), (Throwable)e);
        }
        logger.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }
}

