/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.doc;

import com.tairanchina.csp.dew.Dew;
import com.tairanchina.csp.dew.core.DewConfig;
import com.tairanchina.csp.dew.core.doc.DocClusterAutoConfiguration;
import com.tairanchina.csp.dew.core.doc.DocLocalAutoConfiguration;
import com.tairanchina.csp.dew.core.doc.DocService;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.paths.RelativePathProvider;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ConditionalOnProperty(prefix="dew.basic.doc", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableSwagger2
@ImportAutoConfiguration(value={DocClusterAutoConfiguration.class, DocLocalAutoConfiguration.class})
public class DocAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DocAutoConfiguration.class);
    public static final String FLAG_APPLICATION_NAME = "applicationName";
    @Autowired
    private DewConfig dewConfig;
    @Value(value="${server.context-path:}")
    private String contextPath;

    @Bean
    public DocService docService() {
        return new DocService();
    }

    @Bean
    public Docket restApi(ServletContext servletContext) {
        if (this.dewConfig.getBasic().getDoc().getBasePackage().isEmpty()) {
            return null;
        }
        return new Docket(DocumentationType.SWAGGER_2).tags(new Tag(FLAG_APPLICATION_NAME, Dew.Info.name), new Tag[0]).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.dewConfig.getBasic().getDoc().getBasePackage())).paths(PathSelectors.any()).build().pathProvider((PathProvider)new RelativePathProvider(servletContext){

            public String getApplicationBasePath() {
                return DocAutoConfiguration.this.contextPath + super.getApplicationBasePath();
            }
        });
    }

    private ApiInfo apiInfo() {
        ApiInfoBuilder builder = new ApiInfoBuilder().title(this.dewConfig.getBasic().getName()).description(this.dewConfig.getBasic().getDesc()).termsOfServiceUrl(this.dewConfig.getBasic().getWebSite()).version(this.dewConfig.getBasic().getVersion());
        if (this.dewConfig.getBasic().getDoc().getContact() != null) {
            builder.contact(new Contact(this.dewConfig.getBasic().getDoc().getContact().getName(), this.dewConfig.getBasic().getDoc().getContact().getUrl(), this.dewConfig.getBasic().getDoc().getContact().getEmail()));
        }
        return builder.build();
    }
}

