/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.doc;

import com.tairanchina.csp.dew.core.doc.DocController;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DiscoveryClient.class})
public class DocClusterAutoConfiguration {
    @Autowired
    private DiscoveryClient discoveryClient;

    @Bean
    public DocController docController() {
        return new DocController(() -> this.discoveryClient.getServices().stream().map(serviceId -> {
            ServiceInstance instance = (ServiceInstance)this.discoveryClient.getInstances(serviceId).get(0);
            return instance.getUri() + "/v2/api-docs";
        }).collect(Collectors.toList()));
    }
}

