/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.doc;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.HttpHelper;
import com.ecfront.dew.common.Resp;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocService {
    private static final Logger logger = LoggerFactory.getLogger(DocService.class);

    public Resp<String> generateOfflineDoc(String docName, String docDesc, Map<String, String> visitUrls, List<String> swaggerJsonUrls) throws IOException {
        ArrayList<String> swaggerJsons = new ArrayList<String>();
        for (String url : swaggerJsonUrls) {
            try {
                HttpHelper.ResponseWrap result = $.http.getWrap(url);
                if (result.statusCode == 200) {
                    swaggerJsons.add(result.result);
                    continue;
                }
                logger.warn("Fetch swagger url [" + url + "] error, code:" + result.statusCode);
            }
            catch (IOException e) {
                logger.error("Fetch swagger url [" + url + "] error.", (Throwable)e);
                throw e;
            }
        }
        return this.doGenerateOfflineDoc(docName, docDesc, visitUrls, swaggerJsons);
    }

    public Resp<String> doGenerateOfflineDoc(String docName, String docDesc, Map<String, String> visitUrls, List<String> swaggerJsons) {
        List<JsonNode> swaggers = swaggerJsons.stream().map(json -> $.json.toJson(json)).collect(Collectors.toList());
        StringBuilder asciidocContent = new StringBuilder("= " + docName + "\n" + "" + $.time().yyyy_MM_dd_HH_mm_ss.format(new Date()) + "\n" + ":doctype: book\n" + ":encoding: utf-8\n" + ":lang: zh-CN\n" + ":toc: left\n" + ":toclevels: 4\n" + ":numbered:\n\n");
        asciidocContent.append("=====\n[%hardbreaks]\n" + docDesc + "\n" + "=====\n" + "\n" + "[NOTE]\n" + ".\u63a5\u5165\u5730\u5740\n" + "====\n" + "[%hardbreaks]\n" + visitUrls.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\n")) + "\n" + "====\n" + "\n\n" + "\u672c\u7cfb\u7edf\u5305\u542b\u5982\u4e0b\u670d\u52a1\uff1a\n" + "\n" + "" + swaggers.stream().map(swagger -> ". <<" + this.encode(this.getTag("applicationName", (JsonNode)swagger)) + "," + swagger.path("info").path("title").asText("") + ">>" + " \u63a5\u53e3\u6570:" + this.stream(swagger.path("paths")).mapToLong(JsonNode::size).sum()).collect(Collectors.joining("\n")) + "\n\n");
        swaggers.forEach(swagger -> {
            asciidocContent.append("<<<\n\n[[" + this.encode(this.getTag("applicationName", (JsonNode)swagger)) + "]]\n" + "== " + swagger.path("info").path("title").asText("") + "\n" + "\n" + "[%hardbreaks]\n" + "**\u670d\u52a1\u7b80\u4ecb**: " + swagger.path("info").path("description").asText("") + "\n" + "**\u5f53\u524d\u7248\u672c**: " + swagger.path("info").path("version").asText("") + "\n");
            if (swagger.path("info").has("contact")) {
                asciidocContent.append("**\u5bf9\u63a5\u4fe1\u606f**: " + swagger.path("info").path("contact").path("name").asText("") + "[" + swagger.path("info").path("contact").path("email").asText("") + "]\n");
            }
            asciidocContent.append("**\u63a5\u53e3\u6570\u91cf**: " + this.stream(swagger.path("paths")).mapToLong(JsonNode::size).sum() + "\n");
            asciidocContent.append("**\u670d\u52a1URI**: /" + this.getTag("applicationName", (JsonNode)swagger) + swagger.path("basePath").asText("") + "\n");
            this.stream(swagger.path("tags")).filter(tag -> !tag.path("name").asText().equals("applicationName")).forEach(tag -> {
                String tagName = tag.path("name").asText();
                asciidocContent.append("\n[[" + this.encode(tagName) + "]]\n" + "=== " + tag.path("description").asText() + "\n" + "'''\n");
                this.stream(swagger.path("paths").fields()).forEach(path -> {
                    String uri = (String)path.getKey();
                    this.stream(((JsonNode)path.getValue()).fields()).forEach(apiInfo -> {
                        if (this.array(((JsonNode)apiInfo.getValue()).path("tags")).contains(tagName)) {
                            String httpMethod = (String)apiInfo.getKey();
                            JsonNode api = (JsonNode)apiInfo.getValue();
                            asciidocContent.append("\n[[" + this.encode(httpMethod + " " + uri) + "]]\n" + "==== " + (api.has("deprecated") && api.path("deprecated").asBoolean() ? "[.line-through]#" + api.path("summary").asText() + "#" : api.path("summary").asText()) + "\n" + "'''\n" + "\n" + "----\n" + "" + api.path("description").asText("") + "\n" + "----\n" + "\n" + "\u8bf7\u6c42URI: ``" + httpMethod.toUpperCase() + " " + uri + "``\n" + "[%hardbreaks]\n");
                            if (api.has("consumes")) {
                                asciidocContent.append("consumes: ``" + String.join((CharSequence)";", this.array(api.path("consumes"))) + "``\n");
                            }
                            if (api.has("produces")) {
                                asciidocContent.append("produces: ``" + String.join((CharSequence)";", this.array(api.path("produces"))) + "``\n");
                            }
                            if (api.has("parameters")) {
                                asciidocContent.append("\n\u8bf7\u6c42\u53c2\u6570: \n[options=\"header\", cols=\".^2a,.^10a,.^4a,.^1a,.^10a,.^5a\"]\n|===\n|\u4f4d\u7f6e |\u540d\u79f0 |\u7c7b\u578b |\u5fc5\u586b |\u8bf4\u660e |\u793a\u4f8b \n ");
                                this.stream(api.path("parameters")).filter(p -> !p.path("in").asText().equals("body")).sorted(Comparator.comparing(p -> p.path("in").asText())).forEach(parameter -> {
                                    String typeStr = "";
                                    switch (parameter.path("type").asText("")) {
                                        case "": {
                                            if (parameter.has("items")) {
                                                String valueType = parameter.path("items").path("type").path("additionalProperties").asText("Object");
                                                typeStr = "map<String," + valueType + ">";
                                                break;
                                            }
                                            if (!parameter.has("schema")) break;
                                            typeStr = parameter.path("schema").path("type").asText();
                                            break;
                                        }
                                        case "array": {
                                            if (parameter.has("items")) {
                                                String valueType = parameter.path("items").path("type").asText();
                                                typeStr = "array<" + valueType + ">";
                                                break;
                                            }
                                            if (!parameter.has("schema")) break;
                                            typeStr = "array<" + parameter.path("schema").path("type").asText() + ">";
                                            break;
                                        }
                                        default: {
                                            typeStr = parameter.path("type").asText();
                                        }
                                    }
                                    if (parameter.has("enum")) {
                                        typeStr = this.stream(parameter.path("enum")).map(JsonNode::asText).collect(Collectors.joining("/", "enum:", ""));
                                    }
                                    if (typeStr.isEmpty()) {
                                        logger.warn("Parameter TYPE parse error in " + $.json.toJsonString(parameter));
                                    }
                                    asciidocContent.append("\n").append("|" + parameter.path("in").asText() + "\n").append("|" + parameter.path("name").asText() + "\n").append("|" + typeStr + "\n").append("|" + (parameter.path("required").asBoolean() ? "Y" : "") + "\n").append("|" + parameter.path("description").asText("") + "\n").append("|" + parameter.path("x-example").asText("") + "\n").append("\n");
                                });
                                List bodyParameters = this.stream(api.path("parameters")).filter(p -> p.path("in").asText().equals("body")).collect(Collectors.toList());
                                AtomicLong bodyParameterSize = new AtomicLong(bodyParameters.size());
                                if (bodyParameterSize.get() != 0L) {
                                    String bodyJson = bodyParameters.stream().map(parameter -> {
                                        boolean isArray = false;
                                        String bodyTypeOrStruct = "";
                                        String type = parameter.path("schema").path("type").asText("");
                                        String $ref = parameter.path("schema").path("$ref").asText("");
                                        if (!type.isEmpty()) {
                                            if (type.equals("array")) {
                                                isArray = true;
                                                type = parameter.path("schema").path("items").path("type").asText("");
                                                if (!type.isEmpty()) {
                                                    bodyTypeOrStruct = "<" + type + ">";
                                                } else {
                                                    $ref = parameter.path("schema").path("items").path("$ref").asText("");
                                                }
                                            } else {
                                                bodyTypeOrStruct = "<" + type + ">";
                                            }
                                        }
                                        if (bodyTypeOrStruct.isEmpty() && !$ref.isEmpty()) {
                                            $ref = $ref.substring("#/definitions/".length());
                                            bodyTypeOrStruct = this.fillRelModel(swagger.path("definitions"), $ref, 2, new HashSet<String>());
                                        }
                                        if (bodyTypeOrStruct.isEmpty()) {
                                            logger.warn("Parameter TYPE parse error in " + $.json.toJsonString(parameter));
                                        }
                                        if (isArray) {
                                            bodyTypeOrStruct = "[" + bodyTypeOrStruct + this.level(1) + ",...]";
                                        }
                                        return this.level(1) + "// " + (parameter.path("required").asBoolean() ? "[\u5fc5\u586b]" : "") + parameter.path("description").asText("") + (parameter.has("x-example") ? " e.g. " + parameter.path("x-example").asText() : "") + "\n" + this.level(1) + "\"" + parameter.path("name").asText() + "\":" + bodyTypeOrStruct + (bodyParameterSize.decrementAndGet() == 0L ? "" : ",") + "\n";
                                    }).collect(Collectors.joining("", "{\n", "}\n"));
                                    asciidocContent.append("\n").append("|body\n").append("5+|\n").append("[source]\n").append("----\n").append(bodyJson).append("----\n").append("\n");
                                }
                                asciidocContent.append("\n|===\n");
                            }
                            if (api.has("responses")) {
                                asciidocContent.append("\n\u54cd\u5e94\u7ed3\u679c: \n");
                                String $ref = api.get("responses").path("200").path("schema").path("$ref").asText("");
                                if ($ref.indexOf("#/definitions/Resp") != -1) {
                                    asciidocContent.append("\n").append("[source]\n").append("----\n").append("" + this.parseTypeOrStructBySchema(swagger.path("definitions"), api.get("responses").path("200").path("schema"), 0) + "\n").append("----\n").append("\n");
                                } else {
                                    asciidocContent.append("[options=\"header\", cols=\".^2a,.^10a,.^20a,.^10a\"]\n|===\n|\u72b6\u6001\u7801 |\u8bf4\u660e |\u7c7b\u578b |\u793a\u4f8b \n ");
                                    this.stream(api.get("responses").fields()).forEach(response -> {
                                        String typeOrStruct = this.parseTypeOrStructBySchema(swagger.path("definitions"), ((JsonNode)response.getValue()).get("schema"), 0);
                                        if (!typeOrStruct.trim().isEmpty()) {
                                            typeOrStruct = "[source]\n----\n" + typeOrStruct + "\n----\n";
                                        }
                                        asciidocContent.append("\n").append("|" + (String)response.getKey() + "\n").append("|" + ((JsonNode)response.getValue()).path("description").asText("") + "\n").append("|\n").append(typeOrStruct).append("|" + ((JsonNode)response.getValue()).path("x-example").asText("") + "\n").append("\n");
                                    });
                                    asciidocContent.append("\n|===\n");
                                }
                            }
                        }
                    });
                });
            });
        });
        return Resp.success((Object)asciidocContent.toString());
    }

    private String parseTypeOrStructBySchema(JsonNode definitions, JsonNode schema, int level) {
        try {
            if (schema == null) {
                return "";
            }
            if (schema.has("type")) {
                if (schema.get("type").asText().equals("array")) {
                    if (schema.get("items").has("type")) {
                        return "[" + schema.get("items").get("type").asText() + "]";
                    }
                    return "[" + this.fillRelModel(definitions, schema.get("items").get("$ref").asText().substring("#/definitions/".length()), level + 1, new HashSet<String>()) + "]";
                }
                if (schema.get("type").asText().equals("object") && schema.has("additionalProperties")) {
                    return "{\n" + this.level(level + 1) + "\"<some keys>\":" + this.parseTypeOrStructBySchema(definitions, schema.get("additionalProperties"), level + 2) + "\n" + this.level(level) + "}";
                }
                return schema.get("type").asText();
            }
            return this.fillRelModel(definitions, schema.get("$ref").asText().substring("#/definitions/".length()), level + 1, new HashSet<String>());
        }
        catch (Exception e) {
            logger.warn("Parse schema [" + $.json.toJsonString((Object)schema) + "] error", (Throwable)e);
            return "";
        }
    }

    private String fillRelModel(JsonNode definitions, String modelName, int level, Set<String> filledModels) {
        try {
            if (filledModels.contains(modelName)) {
                return "<\u89c1 " + modelName + ">";
            }
            filledModels.add(modelName);
            if (!definitions.has(modelName)) {
                return "<" + modelName + ">";
            }
            if (modelName.startsWith("Map\u00ab")) {
                return "\"<some keys>\":" + this.parseTypeOrStructBySchema(definitions, definitions.get(modelName).get("additionalProperties"), level + 1);
            }
            List properties = this.stream(definitions.get(modelName).path("properties").fields()).collect(Collectors.toList());
            AtomicLong parameterSize = new AtomicLong(properties.size());
            return properties.stream().map(prop -> {
                boolean isArray = false;
                String bodySubJsonOrSimpleType = "";
                String type = ((JsonNode)prop.getValue()).path("type").asText("");
                String $ref = ((JsonNode)prop.getValue()).path("$ref").asText("");
                if (!type.isEmpty()) {
                    if (type.equals("array")) {
                        isArray = true;
                        type = ((JsonNode)prop.getValue()).path("items").path("type").asText("");
                        if (!type.isEmpty()) {
                            bodySubJsonOrSimpleType = "<" + type + ">";
                        } else {
                            $ref = ((JsonNode)prop.getValue()).path("items").path("$ref").asText("");
                        }
                    } else {
                        bodySubJsonOrSimpleType = "<" + type + ">";
                    }
                }
                if (bodySubJsonOrSimpleType.isEmpty() && !$ref.isEmpty()) {
                    $ref = $ref.substring("#/definitions/".length());
                    bodySubJsonOrSimpleType = this.fillRelModel(definitions, $ref, level + 1, filledModels);
                }
                if (bodySubJsonOrSimpleType.isEmpty()) {
                    logger.warn("Parameter TYPE parse error in " + $.json.toJsonString(prop));
                }
                if (isArray) {
                    bodySubJsonOrSimpleType = "[" + bodySubJsonOrSimpleType + ",...]";
                }
                String desc = ($ref.isEmpty() ? "" : "[\u7c7b\u578b: " + $ref + "] ") + "" + ((JsonNode)prop.getValue()).path("description").asText("");
                return (desc.trim().isEmpty() ? "" : this.level(level) + "// " + desc + "\n") + this.level(level) + "\"" + (String)prop.getKey() + "\":" + bodySubJsonOrSimpleType + (parameterSize.decrementAndGet() == 0L ? "" : ",") + "\n";
            }).collect(Collectors.joining("", "{\n", this.level(level - 1) + "}"));
        }
        catch (Exception e) {
            logger.warn("Fill rel model [" + modelName + "] error.", (Throwable)e);
            return "";
        }
    }

    private String encode(String name) {
        try {
            return "_" + $.security.digest.digest(name, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    private String getTag(String tagName, JsonNode json) {
        Iterator it = json.path("tags").elements();
        while (it.hasNext()) {
            JsonNode curr = (JsonNode)it.next();
            if (!curr.path("name").asText().equals(tagName)) continue;
            return curr.path("description").asText();
        }
        return "";
    }

    private Stream<JsonNode> stream(JsonNode json) {
        return this.stream(json.elements());
    }

    private List<String> array(JsonNode json) {
        return this.stream(json.elements()).map(JsonNode::asText).collect(Collectors.toList());
    }

    private <E> Stream<E> stream(Iterator<E> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private String repeat(String s, int repeat) {
        return new String(new char[repeat]).replace("\u0000", s);
    }

    private String level(int l) {
        return this.repeat(" ", l * 2);
    }
}

