/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.notify;

import com.ecfront.dew.common.Resp;
import com.tairanchina.csp.dew.core.DewConfig;
import com.tairanchina.csp.dew.core.notify.Channel;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsChannel
implements Channel {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isWork = false;
    private DewConfig.Notify notifyConfig;

    @Override
    public void init(DewConfig.Notify notifyConfig) {
        this.isWork = this.innerInit(notifyConfig);
        if (this.isWork) {
            this.notifyConfig = notifyConfig;
            this.logger.info("Init Notify channel:" + this.getClass().getSimpleName());
        }
    }

    abstract boolean innerInit(DewConfig.Notify var1);

    @Override
    public void destroy() {
        if (this.isWork) {
            this.logger.info("Destroy Notify channel:" + this.getClass().getSimpleName());
            this.innerDestroy(this.notifyConfig);
        }
    }

    abstract void innerDestroy(DewConfig.Notify var1);

    @Override
    public boolean send(String content, String title, Set<String> receivers) {
        if (this.isWork) {
            this.logger.trace("Send Notify message [" + this.getClass().getSimpleName() + "]" + title);
            try {
                Resp<String> result = this.innerSend(content, title, receivers);
                if (result.ok()) {
                    return true;
                }
                this.logger.error("Send Notify error [" + result.getCode() + "]" + result.getMessage());
                return false;
            }
            catch (Exception e) {
                this.logger.error("Send Notify error [" + this.getClass().getSimpleName() + "]" + title, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    abstract Resp<String> innerSend(String var1, String var2, Set<String> var3) throws Exception;
}

