/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.notify;

import com.ecfront.dew.common.Resp;
import com.tairanchina.csp.dew.Dew;
import com.tairanchina.csp.dew.core.DewConfig;
import com.tairanchina.csp.dew.core.notify.AbsChannel;
import java.util.Set;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.util.StringUtils;

public class MAILChannel
extends AbsChannel {
    private String emailFrom;
    private JavaMailSender mailSender;

    @Override
    public boolean innerInit(DewConfig.Notify notifyConfig) {
        if (Dew.applicationContext.containsBean("mailSender")) {
            this.mailSender = (JavaMailSender)Dew.applicationContext.getBean("mailSender");
        }
        this.emailFrom = Dew.applicationContext.getEnvironment().getProperty("spring.mail.username", "");
        return this.mailSender != null && !StringUtils.isEmpty((Object)this.emailFrom);
    }

    @Override
    public void innerDestroy(DewConfig.Notify notifyConfig) {
    }

    @Override
    public Resp<String> innerSend(String content, String title, Set<String> receivers) throws Exception {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.emailFrom);
        message.setTo(receivers.toArray(new String[0]));
        message.setSubject(title);
        message.setText(content);
        this.mailSender.send(message);
        return Resp.success((Object)"");
    }
}

