/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.notify;

import com.ecfront.dew.common.Resp;
import com.tairanchina.csp.dew.Dew;
import com.tairanchina.csp.dew.core.DewConfig;
import com.tairanchina.csp.dew.core.notify.Channel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notify {
    private static final Logger logger = LoggerFactory.getLogger(Notify.class);
    private static final Map<String, Channel> NOTIFY_CHANNELS = new HashMap<String, Channel>();
    private static final Map<String, Context> NOTIFY_CONTEXT = new HashMap<String, Context>();
    private static final DelayQueue<NotifyDelayed> DELAY_QUEUE = new DelayQueue();

    public Notify() {
        Dew.dewConfig.getNotifies().forEach((key, value) -> {
            Channel channel = null;
            try {
                channel = (Channel)Class.forName("com.tairanchina.csp.dew.core.notify." + value.getType() + "Channel").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Not exist notify type:" + value.getType());
                System.exit(1);
            }
            channel.init((DewConfig.Notify)value);
            NOTIFY_CHANNELS.put((String)key, channel);
            NOTIFY_CONTEXT.put((String)key, new Context());
        });
        this.delaySend();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> NOTIFY_CHANNELS.values().forEach(Channel::destroy)));
    }

    public void sendAsync(String flag, String content) {
        this.sendAsync(flag, content, "");
    }

    public void sendAsync(String flag, String content, String title) {
        this.sendAsync(flag, content, title, new HashSet<String>());
    }

    public void sendAsync(String flag, String content, String title, Set<String> specialReceivers) {
        Dew.Util.newThread(() -> this.send(flag, content, title, specialReceivers));
    }

    public void sendAsync(String flag, Throwable content) {
        this.sendAsync(flag, content, "");
    }

    public void sendAsync(String flag, Throwable content, String title) {
        this.sendAsync(flag, content, title, new HashSet<String>());
    }

    public void sendAsync(String flag, Throwable content, String title, Set<String> specialReceivers) {
        Dew.Util.newThread(() -> this.send(flag, content, title, specialReceivers));
    }

    public Resp<Void> send(String flag, String content) {
        return this.send(flag, content, "");
    }

    public Resp<Void> send(String flag, String content, String title) {
        return this.send(flag, content, title, new HashSet<String>());
    }

    public Resp<Void> send(String flag, Throwable content) {
        return this.send(flag, content, "");
    }

    public Resp<Void> send(String flag, Throwable content, String title) {
        return this.send(flag, content, title, new HashSet<String>());
    }

    public Resp<Void> send(String flag, Throwable content, String title, Set<String> specialReceivers) {
        return this.send(flag, Arrays.stream(content.getStackTrace()).map(StackTraceElement::toString).limit(10L).collect(Collectors.joining("\n")), title, specialReceivers);
    }

    public Resp<Void> send(String flag, String content, String title, Set<String> specialReceivers) {
        return this.send(flag, content, title, specialReceivers, false);
    }

    private Resp<Void> send(String flag, String content, String title, Set<String> specialReceivers, boolean force) {
        Channel channel = NOTIFY_CHANNELS.getOrDefault(flag, null);
        if (channel == null) {
            logger.trace("Not found notify flag[" + flag + "] in dew config.");
            return Resp.badRequest((String)("Not found notify flag[" + flag + "] in dew config."));
        }
        DewConfig.Notify notifyConfig = Dew.dewConfig.getNotifies().get(flag);
        Context notifyContext = NOTIFY_CONTEXT.get(flag);
        if (!force && notifyConfig.getStrategy().getMinIntervalSec() != 0) {
            if (notifyContext.intervalNotifyCounter.getAndIncrement() > -1L) {
                logger.trace("Notify frequency must be > " + notifyConfig.getStrategy().getMinIntervalSec() + "s");
                return Resp.locked((String)("Notify frequency must be > " + notifyConfig.getStrategy().getMinIntervalSec() + "s"));
            }
            DELAY_QUEUE.offer(new NotifyDelayed(flag, specialReceivers, notifyConfig.getStrategy().getMinIntervalSec() * 1000));
        }
        boolean isDNDTime = false;
        if (!notifyConfig.getStrategy().getDndTime().isEmpty()) {
            String[] dndTime = notifyConfig.getStrategy().getDndTime().split("-");
            Calendar time = Calendar.getInstance();
            long currentTime = Long.valueOf(new SimpleDateFormat("yyyyMMddHHmm").format(time.getTime()));
            int currentShortTime = Integer.valueOf(new SimpleDateFormat("HHmm").format(time.getTime()));
            int dndStartShortTime = Integer.valueOf(dndTime[0].replace(":", ""));
            int dndEndShortTime = Integer.valueOf(dndTime[1].replace(":", ""));
            if (dndEndShortTime == dndStartShortTime) {
                isDNDTime = true;
            } else if (dndEndShortTime - dndStartShortTime >= 0) {
                isDNDTime = currentShortTime >= dndStartShortTime && currentShortTime <= dndEndShortTime;
            } else {
                isDNDTime = currentShortTime >= dndStartShortTime || currentShortTime <= dndEndShortTime;
                time.add(5, 1);
            }
            if (currentTime > notifyContext.lastDNDEndTime.getAndSet(Long.valueOf(new SimpleDateFormat("yyyyMMdd").format(time.getTime()) + dndTime[1].replace(":", "")))) {
                notifyContext.currentForceSendTimes.set(0);
            }
            if (!force && isDNDTime && notifyConfig.getStrategy().getForceSendTimes() > notifyContext.currentForceSendTimes.incrementAndGet()) {
                logger.trace("Do Not Disturb time and try notify times <=" + notifyConfig.getStrategy().getForceSendTimes());
                return Resp.locked((String)("Do Not Disturb time and try notify times <=" + notifyConfig.getStrategy().getForceSendTimes()));
            }
        }
        HashSet<String> receivers = new HashSet<String>();
        if (isDNDTime) {
            receivers.addAll(notifyConfig.getDndTimeReceivers());
        } else {
            receivers.addAll(notifyConfig.getDefaultReceivers());
            receivers.addAll(specialReceivers);
        }
        title = (title != null ? title : "") + " FROM " + Dew.Info.instance + " BY " + flag;
        title = title.replaceAll("\"", "'");
        content = content.replaceAll("\"", "'");
        boolean result = channel.send(content, title, receivers);
        if (result) {
            return Resp.success(null);
        }
        logger.warn("Notify send error.");
        return Resp.serverError((String)"Notify send error.");
    }

    private void delaySend() {
        Dew.Util.newThread(() -> {
            while (true) {
                try {
                    while (true) {
                        NotifyDelayed notifyDelayed = (NotifyDelayed)DELAY_QUEUE.take();
                        String flag = notifyDelayed.getFlag();
                        Context notifyContext = NOTIFY_CONTEXT.get(flag);
                        long notifyCounter = notifyContext.intervalNotifyCounter.getAndSet(-1L);
                        int delayMs = notifyDelayed.getDelayMs();
                        Set<String> specialReceivers = notifyDelayed.getSpecialReceivers();
                        Dew.Util.newThread(() -> this.send(flag, "\u5728\u6700\u8fd1\u7684[" + delayMs / 1000 + "]\u79d2\u5185\u53d1\u751f\u4e86[" + notifyCounter + "]\u6b21\u901a\u77e5\u8bf7\u6c42\u3002", "\u5ef6\u65f6\u901a\u77e5", specialReceivers, true));
                    }
                }
                catch (InterruptedException e) {
                    logger.error("Send delay notify error.", (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    static class NotifyDelayed
    implements Delayed {
        private String flag;
        private Set<String> specialReceivers;
        private int delayMs;
        private long expireMs;

        public String getFlag() {
            return this.flag;
        }

        public Set<String> getSpecialReceivers() {
            return this.specialReceivers;
        }

        public int getDelayMs() {
            return this.delayMs;
        }

        public NotifyDelayed(String flag, Set<String> specialReceivers, int delayMs) {
            this.flag = flag;
            this.specialReceivers = specialReceivers;
            this.delayMs = delayMs;
            this.expireMs = (long)delayMs + System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }
    }

    static class Context {
        AtomicLong intervalNotifyCounter = new AtomicLong(-1L);
        AtomicLong lastDNDEndTime = new AtomicLong(0L);
        AtomicInteger currentForceSendTimes = new AtomicInteger(0);

        Context() {
        }
    }
}

