/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.web.error;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.Resp;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.tairanchina.csp.dew.Dew;
import com.tairanchina.csp.dew.core.DewConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.catalina.connector.RequestFacade;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@ConditionalOnWebApplication
@RequestMapping(value={"${error.path:/error}"})
public class ErrorController
extends AbstractErrorController {
    private static final Logger logger = LoggerFactory.getLogger(ErrorController.class);
    private static final int FALL_BACK_STATUS = 500;
    private static final Pattern MESSAGE_CHECK = Pattern.compile("^\\{\"code\":\"\\w*\",\"message\":\".*\",\"customHttpCode\":.*}$");
    private static final String SPECIAL_ERROR_FLAG = "org.springframework.boot.autoconfigure.web.DefaultErrorAttributes.ERROR";
    private static final String DETAIL_FLAG = "\tDetail:";
    @Value(value="${error.path:/error}")
    private String errorPath;

    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        return new MethodValidationPostProcessor();
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    @RequestMapping
    @ResponseBody
    public Object error(HttpServletRequest request) {
        Object specialError = request.getAttribute(SPECIAL_ERROR_FLAG);
        if (specialError instanceof Resp.FallbackException) {
            return ResponseEntity.status((int)500).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)((Resp.FallbackException)specialError).getMessage());
        }
        Map error = this.getErrorAttributes(request, true);
        String path = error.containsKey("path") ? error.getOrDefault("path", Dew.context().getRequestUri()) : ((RequestFacade)((ServletRequestWrapper)request).getRequest()).getRequestURI();
        int statusCode = error.getOrDefault("status", -1);
        String message = error.getOrDefault("message", "").toString();
        String exClass = error.getOrDefault("exception", "");
        String exMsg = error.getOrDefault("error", "");
        List exDetail = null;
        if (error.containsKey("errors") && !((List)error.get("errors")).isEmpty()) {
            exDetail = (List)error.get("errors");
        }
        Object[] result = ErrorController.error(request, path, statusCode, message, exClass, exMsg, exDetail, (Throwable)specialError);
        if (statusCode > 499) {
            Dew.notify.sendAsync(Dew.dewConfig.getBasic().getFormat().getErrorFlag(), (Throwable)specialError, ((Throwable)specialError).getMessage());
        }
        return ResponseEntity.status((int)((Integer)result[0])).contentType(MediaType.APPLICATION_JSON_UTF8).body(result[1]);
    }

    private static Object[] error(HttpServletRequest request, String path, int statusCode, String msg, String exClass, String exMsg, List exDetail, Throwable specialError) {
        ArrayNode errorExt;
        String message = msg;
        String requestFrom = request.getHeader("Request-From");
        int httpCode = statusCode;
        int customHttpCode = -1;
        String busCode = String.valueOf(statusCode);
        if (!StringUtils.isEmpty((Object)exClass) && Dew.dewConfig.getBasic().getErrorMapping().containsKey(exClass)) {
            DewConfig.Basic.ErrorMapping errorMapping = Dew.dewConfig.getBasic().getErrorMapping().get(exClass);
            if (!StringUtils.isEmpty((Object)errorMapping.getHttpCode())) {
                customHttpCode = errorMapping.getHttpCode();
            }
            if (!StringUtils.isEmpty((Object)errorMapping.getBusinessCode())) {
                busCode = errorMapping.getBusinessCode();
            }
            if (!StringUtils.isEmpty((Object)errorMapping.getMessage())) {
                message = errorMapping.getMessage();
            }
        }
        if (MESSAGE_CHECK.matcher(message).matches()) {
            JsonNode detail = $.json.toJson((Object)message);
            busCode = detail.get("code").asText();
            message = detail.get("message").asText();
            if (detail.has("customHttpCode") && detail.get("customHttpCode").asInt() != -1) {
                customHttpCode = detail.get("customHttpCode").asInt();
            }
        }
        if (specialError instanceof ConstraintViolationException) {
            errorExt = $.json.createArrayNode();
            ((ConstraintViolationException)specialError).getConstraintViolations().forEach(cv -> errorExt.add((JsonNode)$.json.createObjectNode().put("field", "").put("reason", ((ConstraintDescriptorImpl)cv.getConstraintDescriptor()).getAnnotationType().getSimpleName()).put("msg", cv.getMessage())));
            message = message + DETAIL_FLAG + $.json.toJsonString((Object)errorExt);
        }
        if (specialError instanceof MethodArgumentNotValidException && exDetail != null && !exDetail.isEmpty()) {
            errorExt = $.json.createArrayNode();
            for (JsonNode json : $.json.toJson((Object)exDetail)) {
                errorExt.add((JsonNode)$.json.createObjectNode().put("field", json.get("field").asText("")).put("reason", json.get("codes").get(0).asText().split("\\.")[0]).put("msg", json.get("defaultMessage").asText("")));
            }
            message = message + DETAIL_FLAG + $.json.toJsonString((Object)errorExt);
        }
        logger.error("Request [{}-{}] from [{}] {} , error {} : {}", new Object[]{request.getMethod(), path, requestFrom, Dew.context().getSourceIP(), busCode, message});
        if (specialError instanceof ConstraintViolationException) {
            busCode = "400";
            httpCode = 400;
        }
        httpCode = customHttpCode != -1 ? customHttpCode : (httpCode >= 500 && httpCode < 600 ? 500 : 200);
        Resp resp = Resp.customFail((String)(busCode + ""), (String)("[" + exMsg + "]" + message));
        String body = $.json.toJsonString((Object)resp);
        return new Object[]{httpCode, body};
    }

    public static void error(HttpServletRequest request, HttpServletResponse response, int statusCode, String message, String exClass) throws IOException {
        Object[] confirmedError = ErrorController.error(request, request.getRequestURI(), statusCode, message, exClass, "", null, null);
        response.setStatus(((Integer)confirmedError[0]).intValue());
        response.setContentType(String.valueOf(MediaType.APPLICATION_JSON_UTF8));
        response.getWriter().write((String)confirmedError[1]);
        response.getWriter().flush();
        response.getWriter().close();
    }
}

