/*
 * Decompiled with CFR 0.152.
 */
package com.tairanchina.csp.dew.core.web.interceptor;

import com.ecfront.dew.common.$;
import com.tairanchina.csp.dew.Dew;
import com.tairanchina.csp.dew.core.DewContext;
import com.tairanchina.csp.dew.core.web.error.ErrorController;
import java.net.URLDecoder;
import javax.security.auth.message.AuthException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class BasicHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BasicHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestFrom = request.getHeader("Request-From");
        if (Dew.dewConfig.getSecurity().getIncludeServices() != null) {
            for (String v : Dew.dewConfig.getSecurity().getIncludeServices()) {
                if (v.equalsIgnoreCase(requestFrom)) continue;
                ErrorController.error(request, response, 401, "The [" + requestFrom + "] does NOT allow access to this service.", AuthException.class.getName());
                return false;
            }
        }
        if (Dew.dewConfig.getSecurity().getIncludeServices() == null && Dew.dewConfig.getSecurity().getExcludeServices() != null) {
            for (String v : Dew.dewConfig.getSecurity().getExcludeServices()) {
                if (!v.equalsIgnoreCase(requestFrom)) continue;
                ErrorController.error(request, response, 401, "The [" + requestFrom + "] does NOT allow access to this service.", AuthException.class.getName());
                return false;
            }
        }
        response.addHeader("Access-Control-Allow-Origin", Dew.dewConfig.getSecurity().getCors().getAllowOrigin());
        response.addHeader("Access-Control-Allow-Methods", Dew.dewConfig.getSecurity().getCors().getAllowMethods());
        response.addHeader("Access-Control-Allow-Headers", Dew.dewConfig.getSecurity().getCors().getAllowHeaders());
        response.addHeader("Access-Control-Max-Age", "3600000");
        response.addHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        if (request.getMethod().equalsIgnoreCase("OPTIONS") || request.getMethod().equalsIgnoreCase("HEAD")) {
            return super.preHandle(request, response, handler);
        }
        String token = Dew.dewConfig.getSecurity().isTokenInHeader() ? request.getHeader(Dew.dewConfig.getSecurity().getTokenFlag()) : request.getParameter(Dew.dewConfig.getSecurity().getTokenFlag());
        if (token != null) {
            token = URLDecoder.decode(token, "UTF-8");
            if (Dew.dewConfig.getSecurity().isTokenHash()) {
                token = $.security.digest.digest(token, "MD5");
            }
        }
        DewContext context = new DewContext();
        context.setId($.field.createUUID());
        context.setSourceIP(Dew.Util.getRealIP(request));
        context.setRequestUri(request.getRequestURI());
        context.setToken(token);
        DewContext.setContext(context);
        logger.trace("[{}] {}{} from {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getQueryString() == null ? "" : "?" + request.getQueryString(), Dew.context().getSourceIP()});
        return super.preHandle(request, response, handler);
    }
}

