/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<E> {
    final ConcurrentMap<String, CacheEntry<E>> cache = new ConcurrentHashMap<String, CacheEntry<E>>();

    public void put(String key, E e, long ttlMs) {
        if (key == null || e == null) {
            return;
        }
        CacheEntry<E> entry = new CacheEntry<E>(e, System.currentTimeMillis() + ttlMs);
        this.cache.put(key, entry);
    }

    public E get(String key) {
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry != null && entry.expireTime > System.currentTimeMillis()) {
            return entry.value;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry<E> {
        final long expireTime;
        final E value;

        public CacheEntry(E value, long expire) {
            this.expireTime = expire;
            this.value = value;
        }
    }
}

