package com.taobao.hsf.junit;

import com.taobao.hsf.standalone.HSFEasyStarter;
import com.taobao.hsf.standalone.HSFStarter;
import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.IOUtil;
import com.taobao.middleware.pandora.toolkit.SarFetcher;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author bw on 10/31/15.
 */
class DefaultBehavior implements Behavior {
    private PandoraClassLoader classLoader;
    private Map<String, String> properties = Collections.emptyMap();

    DefaultBehavior(Class<?> clazz) {
        processSystemProperties(clazz);
        processSar(clazz);
    }

    private void processSystemProperties(Class<?> clazz) {
        SystemProperties systemProperties = clazz.getAnnotation(SystemProperties.class);
        if (systemProperties == null) return;
        Property[] properties = systemProperties.value();
        if (properties == null) return;
        this.properties = new HashMap<String, String>();
        for (Property property : properties) {
            this.properties.put(property.key(), property.value());
        }
    }

    @Override
    public void before() {
        for (String key : properties.keySet()) {
            System.setProperty(key, properties.get(key));
            System.out.println("[HSFRunner] set system property: " + key + "->" + properties.get(key));
        }
    }

    @Override
    public void after() {
        for (String key : properties.keySet()) {
            System.clearProperty(key);
        }
        System.clearProperty("com.taobao.pandora.tmp_path");
    }

    private void processSar(Class<?> clazz) {
        Sar sarInfo = clazz.getAnnotation(Sar.class);
        String location = HSFEasyStarter.DEFAULT_RELEASE_PATH;
        String version = SarFetcher.getRecommendedSarVersion();
        if (sarInfo != null) {
            location = sarInfo.location().isEmpty() ? location : sarInfo.location();
            version = sarInfo.version();
        }
        location = IOUtil.buildDirPath(location, version);
        try {
            location = HSFSarUtil.prepareHSFSar(location,version);
        } catch (IOException e) {
            throw new RuntimeException("HSFMiniContainer.start(sarPath) fail, please check your sar under path: " + location, e);
        }
        System.setProperty("com.taobao.pandora.tmp_path", location + File.separatorChar + "tmp");
        System.out.println("[HSFRunner] setup sar " + version + " at " + location);

        try {
            HSFSarUtil.prepareHSFSar(location, version);
            classLoader = new PandoraClassLoader();
            HSFStarter.start(location, classLoader);
            Map<String, Class<?>> cache = HSFRunner.findClassCache();
            classLoader.setClassCache(cache);
        } catch (Exception e) {
            System.err.println("[HSFRunner] fail to prepare sar");
            e.printStackTrace();
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }
}
