package com.taobao.hsf.junit;

import java.util.Map;

/**
 * @author bw on 10/31/15.
 */
class ExistingCacheBehavior implements Behavior {
    private ClassLoader classLoader;

    ExistingCacheBehavior(Map<String, Class<?>> classCache, Class clazz) {
        System.out.println("[HSFRunner] sar is already setup, reuse");
        Class hsfClass = classCache.get("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
        if (hsfClass != null) {
            try {
                Class bizClass = hsfClass.getClassLoader().loadClass(clazz.getName());
                classLoader = bizClass.getClassLoader();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            classLoader = clazz.getClassLoader();
        }
    }

    @Override
    public void before() {
        // no op
    }

    @Override
    public void after() {
        // no op
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }
}
