package com.taobao.hsf.junit;

import com.taobao.hsf.standalone.HSFStarter;

import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;

/**
 * @author bw on 10/26/15.
 */
class PandoraClassLoader extends URLClassLoader {
    private Map<String, Class<?>> classCache = Collections.emptyMap();

    PandoraClassLoader() {
        super(((URLClassLoader) getSystemClassLoader()).getURLs(), getSystemClassLoader().getParent());
    }

    void setClassCache(Map<String, Class<?>> classCache) {
        this.classCache = classCache;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (classCache.containsKey(name)) {
            return classCache.get(name);
        }

        // 1. junit classes are bootstrap from system classloader
        // 2. delegate HSFStarter to system classloader in order to make sure classes map is singleton
        if (name.startsWith("org.junit.") || name.equals(HSFStarter.class.getName())) {
            return getSystemClassLoader().loadClass(name);
        }
        return super.loadClass(name);
    }
}
