package com.taobao.hsf.lightapi.mock;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author lanshan
 */
public class MethodUtil {

    /**
     * 通过方法名获取对应的方法，如果有重载方法，会抛出UnsupportedOperationException
     * @param targetClazz
     * @param methodName
     * @return
     * @throws NoSuchMethodException
     */
    public static Method getMethodByName(Class<?> targetClazz, String methodName) throws NoSuchMethodException {
        assert targetClazz != null && methodName != null;

        List<Method> methodsMatched = new ArrayList<Method>();
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                if (method.getName().startsWith(methodName)) {
                    methodsMatched.add(method);
                }
            }
        }

        if (methodsMatched.size() > 1) {
            throw new UnsupportedOperationException("There are more than one Method startWith methodName[" + methodName + "],please use getMethodByNameAndTypes()");
        } else if (methodsMatched.size() == 1) {
            return methodsMatched.get(0);
        } else {
            throw new NoSuchMethodException("There is no method which name startWith [" + methodName + "].");
        }
    }

    /**
     * 通过方法名、参数类型获取对应的方法
     * @param targetClazz
     * @param methodName
     * @param argsType 无参请写new String[0]
     * @return
     * @throws NoSuchMethodException
     */
    public static Method getMethodByNameAndTypes(Class<?> targetClazz, String methodName, String[] argsType) throws NoSuchMethodException {
        assert targetClazz != null && methodName != null;
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                String[] methodArgTypes;
                if (parameterTypes.length > 0) {
                    methodArgTypes = new String[parameterTypes.length];
                    int index = 0;
                    for (Class<?> paramType : parameterTypes) {
                        methodArgTypes[index++] = paramType.getName();
                    }
                } else {
                    methodArgTypes = new String[0];
                }
                if (methodName.equals(method.getName()) && Arrays.equals(methodArgTypes, argsType)) {
                    return method;
                }
            }
        }
        throw new NoSuchMethodException("There is no method which name is [" + methodName + "] and arguments types are [" + argsType + "]");
    }

    /**
     * 通过方法名的起始字符来获取所有重载、类似的方法，不支持通配
     * @param targetClazz
     * @param methodNamePattern
     * @return
     */

    public static List<Method> getMethodsStartWithNamePattern(Class<?> targetClazz, String methodNamePattern) throws NoSuchMethodException{
        assert targetClazz != null && methodNamePattern != null;

        List<Method> methodsMatched = new ArrayList<Method>();
        Method[] allMethods = targetClazz.getMethods();
        if (allMethods != null && allMethods.length > 0) {
            for (Method method : allMethods) {
                if (method.getName().startsWith(methodNamePattern)) {
                    methodsMatched.add(method);
                }
            }
        }

        if(methodsMatched.isEmpty())
            new NoSuchMethodException("There is no method which name is startWith[" + methodNamePattern+ "]");
        return methodsMatched;
    }
}
