package com.taobao.hsf.lightapi.mock;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by huangsheng.hs on 2015/7/17.
 */
public class MockContext {
    private ThreadLocal<Map<Object, Object>> mockContext = new ThreadLocal<Map<Object, Object>>() {
        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>();
        }
    };

    @SuppressWarnings("unchecked")
    public <T> T get(final Method method) {
        Map<Object, Object> map = mockContext.get();
        return (T) map.get(method);
    }


    public void put(final Method method, final Object returnValue) {
        Map<Object, Object> map = mockContext.get();
        map.put(method,returnValue);
    }

    public void set(final Map<String, Object> methodAndReturnValue) {
        Map<Object, Object> map = mockContext.get();
        map.putAll(methodAndReturnValue);
    }

    public void remove() {
        mockContext.remove();
    }

    @SuppressWarnings("unchecked")
    public <T> T remove(final Method method) {
        Map<Object, Object> map = mockContext.get();
        return (T) map.remove(method);
    }
}

