package com.taobao.hsf.lightapi.report;

import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.lightapi.util.ReportUtil;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created by huangsheng.hs on 2015/7/22.
 */
public class LightApiReporter {
    private ExecutorService reporter = Executors.newSingleThreadExecutor();
    private AtomicBoolean reportSuccess = new AtomicBoolean(false);

    public void doReport() {
        reporter.execute(new ReportTask());
    }

    class ReportTask implements Runnable {

        /**
         * When an object implementing interface <code>Runnable</code> is used
         * to create a thread, starting the thread causes the object's
         * <code>run</code> method to be called in that separately executing
         * thread.
         * <p>
         * The general contract of the method <code>run</code> is that it may
         * take any action whatsoever.
         *
         * @see Thread#run()
         */
        @Override
        public void run() {
            String ip = ReportUtil.getIP();
            String version = ReportUtil.getVersion();

            if (version.equals("unknown") || ip == null)
                return;
            try {
                int retryTimes = 0;
                while (!report(ip, version) && retryTimes < 3) {
                    retryTimes++;
                }
            } catch (Exception e) {
                ; // ignore error message, shush~
            }
        }

        private boolean report(String ip, String version) {
            String reportUrl = LightConstant.reportUrl + "?ip=" + ip + "&version=" + version;
            URL url = null;
            InputStream in = null;
            try {
                url = new URL(reportUrl);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(3000);
                conn.connect();
                conn.setReadTimeout(3000);
                in = conn.getInputStream();

                byte[] resultBytes = new byte[128];
                int count = 0;
                int temp = 0;
                while ((temp = in.read(resultBytes)) != -1) {
                    count += temp;
                    continue;
                }
                StringBuilder sb = new StringBuilder(new String(resultBytes, 0, count));
                char[] resultChars = new char[128];
                sb.getChars(0, sb.length(), resultChars, 0);

                int i;
                for (i = 0; i < resultChars.length; i++) {
                    if (Character.isISOControl(resultChars[i]))
                        continue;
                    else
                        break;
                }

                String trueResult = sb.substring(i, sb.length()).toString().trim();
                if (trueResult.contains("success")) {
                    reportSuccess.compareAndSet(false, true);
                    return true;
                } else {
                    return false;
                }
            } catch (Exception e) {
                ;   // ignore error message
                return false;
            } finally {
                if (in != null) {    // quick & ugly
                    try {
                        in.close();
                    } catch (IOException e) {
                        ; // ignore error message
                    }
                }
            }
        }
    }

    public boolean isReportSuccess() {
        return reportSuccess.get();
    }
}
