package com.taobao.hsf.lightapi.util;

import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.app.spring.util.SuperHSFSpringConsumerBeanTop;
import com.taobao.hsf.standalone.util.Constant;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.taobao.hsf.lightapi.util.ReflectionUtil.getField;
import static com.taobao.hsf.lightapi.util.ReflectionUtil.invoke;
import static com.taobao.hsf.lightapi.util.ReflectionUtil.staticInvoke;


/**
 * Created by huangsheng.hs on 2014/11/28.
 */
public class Partner {

    public static void waitServiceReady(Object... serviceList) {
        int timePerSleep = 5;
        int totalTimeout = 15000;
        int sleepTime = 0;
        try {
            for (Object service : serviceList) {
                if (sleepTime > totalTimeout) {
                    System.out.println("Service : " + "configServer pushing address timeout: " + totalTimeout + "ms");
                    break;
                }

                while (!isServiceAddressReadyFromHSFSpringConsumerBean(service)) {
                    Thread.sleep(timePerSleep);
                    sleepTime += timePerSleep;
                    if (sleepTime > totalTimeout) {
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static boolean isServiceAddressReadyForTop(SuperHSFSpringConsumerBeanTop service)
            throws Exception {
        ClassLoader loader = SuperHSFSpringConsumerBeanTop.class.getClassLoader();
        if (Constant.main_version == 1) {
            Class
                    serviceHolderClazz =
                    Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true,
                            loader);
            Object metaService = staticInvoke(serviceHolderClazz, "getMetadataService");
            Object addrService = getField(metaService, "addressService");
            Object metadata = getField(service, "metadata");
            String serviceUniqueName = (String) invoke(metadata, "getUniqueName");
            Object
                    routeResultCache =
                    invoke(addrService, "getRouteResultCache", serviceUniqueName);
            Object addrList = invoke(routeResultCache, "getInterfaceAddresses");
            int size = (Integer) invoke(addrList, "size");
            return size > 0;
        } else {
            Class
                    serviceHolderClazz =
                    Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object addressComponent = staticInvoke(serviceHolderClazz, "getInstance",
                    Class.forName(
                            "com.taobao.hsf.address.AddressService",
                            true, loader));
            Object addressPool = getField(addressComponent, "addressPool");
            Method m1 = service.getClass().getMethod("getInterfaceName");
            Method m2 = service.getClass().getMethod("getVersion");
            String uniqueName = m1.invoke(service, null) + ":" + m2.invoke(service, null);
            Object addressBucket = invoke(addressPool, "getAddressBucket", uniqueName);
            Object addrList = invoke(addressBucket, "getAllAddresses");
            int size = (Integer) invoke(addrList, "size");
            return size > 0;
        }
    }

    private static boolean isServiceAddressReadyFromHSFSpringConsumerBean(Object service)
            throws Exception {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();

        if (Constant.main_version == 1) {
            Class
                    serviceHolderClazz =
                    Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true,
                            loader);
            Object metaService = staticInvoke(serviceHolderClazz, "getMetadataService");
            Object addrService = getField(metaService, "addressService");
            Object routeResultCache = invoke(addrService, "getRouteResultCache",
                    serviceName(
                            service));
            Object addrList = invoke(routeResultCache, "getInterfaceAddresses");
            int size = (Integer) invoke(addrList, "size");
            return size > 0;
        } else {
            Class
                    serviceHolderClazz =
                    Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object addressComponent = staticInvoke(serviceHolderClazz, "getInstance",
                    Class.forName(
                            "com.taobao.hsf.address.AddressService",
                            true, loader));
            Object addressPool = getField(addressComponent, "addressPool");
            Object addressBucket = invoke(addressPool, "getAddressBucket",
                    serviceName(service));
            Object addrList = invoke(addressBucket, "getAllAddresses");
            int size = (Integer) invoke(addrList, "size");
            return size > 0;
        }
    }

    public static List<String> allAddresses(String serviceName) {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        Object addrList = null;
        Class serviceHolderClazz;
        try {
            serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object addressComponent = staticInvoke(serviceHolderClazz, "getInstance",
                    Class.forName(
                            "com.taobao.hsf.address.AddressService",
                            true, loader));
            Object addressPool = getField(addressComponent, "addressPool");
            Object addressBucket = invoke(addressPool, "getAddressBucket",
                    serviceName);
            addrList = invoke(addressBucket, "getAllAddresses");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return addrList == null ? new ArrayList<String>() : (List<String>) addrList;
    }

    public static void setRunModeToTest(){
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        try{
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
            Object configurationService = staticInvoke(serviceHolderClazz,"getInstance",Class.forName("com.taobao.hsf.configuration.service.ConfigurationService",true,loader));
            Field runModeFiled = configurationService.getClass().getDeclaredField("runmode");
            runModeFiled.setAccessible(true);
            runModeFiled.set(configurationService,0);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean publishSuccess(Object providerBean) {
        try {
            Object apiBean = getField(providerBean, "providerBean");
            Object metadata = getField(apiBean, "metadata");
            AtomicBoolean readyToPublish = (AtomicBoolean) getField(metadata, "readyToPublish");
            return readyToPublish.get();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static String serviceName(Object serviceProxy) throws Exception {
        Object hsfProxy = Proxy.getInvocationHandler(serviceProxy);
        Object metadata = getField(hsfProxy, "serviceConsumerMetadata");
        String uniqueName = (String) invoke(metadata, "getUniqueName");
        return uniqueName;
    }

}
