package com.taobao.hsf.lightapi.util;

import com.taobao.hsf.lightapi.ServiceFactory;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;

/**
 * Created by huangsheng.hs on 2015/7/22.
 */
public class ReportUtil {
    private static volatile String IP;
    private static volatile String version;
    private static final String UNKNOWN_VERSION = "unknown";

    public static String getVersion(){
        if(version == null){
           version = getLightApiVersion();
        }
        return version;
    }

    public static String getIP() {

        if (IP == null) {
            IP = getInetAddress();
        }
        return IP;
    }

    /**
     * 获得本机IP。<br />
     * 在超过一块网卡时会有问题，因为这里每次都只是取了第一块网卡绑定的IP地址
     */
    private static String getInetAddress() {
        try {
            String ip = System.getProperty("hsf.server.ip");
            if (StringUtils.isNotEmpty(ip)) {
                return ip;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (!address.isLoopbackAddress() && address.getHostAddress().indexOf(":") == -1){
                        return address.getHostAddress();
                    }
                }
            }
            return null;
        } catch (Throwable t) {
            return null;
        }
    }

    private static String getLightApiVersion() {
        String hackVersion = System.getProperty("hack.version");
        if(hackVersion != null)
            return hackVersion;

        // agent 和 jdk 的类拿不到protectionDomain，增加盘空逻辑
        Class<?> clazz = ServiceFactory.class;
        String jarName = "unknown";
        if (clazz.getProtectionDomain() != null
                && clazz.getProtectionDomain().getCodeSource() != null
                && clazz.getProtectionDomain().getCodeSource().getLocation() != null) {
            jarName = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        }
        if(!jarName.endsWith(".jar"))// develop
            return "unknown";

        String jarDirectory = jarName.substring(0,jarName.lastIndexOf("/"));
        String version = jarDirectory.substring(jarDirectory.lastIndexOf("/") + 1,jarDirectory.length());
        return "LightApi-" + version;
    }
    public static void main(String[] args){
        getLightApiVersion();
    }

}
