package com.taobao.hsf.lightapi.util;

import com.taobao.hsf.util.HSFConstants;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.hsf.util.ThreadLocalUtil;

/**
 * Created by arthur on 16/4/11.
 */
public class RequestContextUtil {
    /**
     * @return 发起该次请求的客户端ip
     */
    public static String getClientIp() {
        return ThreadLocalUtil.get(HSFConstants.TL_KEY_REMOTE_IP);
    }

    /**
     * @return 发起该次请求的客户端AppName
     */
    public static String getAppNameOfClient() {
        return ThreadLocalUtil.get(HSFConstants.TL_KEY_APPNAME_OF_CONSUMER);
    }

    /**
     * 设置这次HSF请求的目标服务器
     * @param ip
     * @return
     */
    public static void setTargetServerIp(String ip) {
        ThreadLocalUtil.set(HSFConstants.TL_KEY_TARGET_SERVER_IP,ip);
    }

    public static String getTargetServerIp() {
        return ThreadLocalUtil.remove(HSFConstants.TL_KEY_TARGET_SERVER_IP);
    }

    public static String getLocalIp() {
        return InetAddressUtil.getIP();
    }

    public static void setUserId(long userId){
        ThreadLocalUtil.set(HSFConstants.KEY_UNIT_DEPLOY_USER_ID,userId);
    }

    public static void setRequestTimeout(int timeout) {
        ThreadLocalUtil.set(HSFConstants.TL_KEY_REQUEST_TIMEOUT, timeout);
    }


    public static void setProviderIp(String ip){
        ThreadLocalUtil.set(HSFConstants.TARGET_SERVER_IP,ip);
    }

    public static String getProviderIp(){
        return ThreadLocalUtil.remove(HSFConstants.TARGET_SERVER_IP);
    }
}

