package com.taobao.hsf.standalone;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 在ExtClassLoader和Bootstrap ClassLoader链之间插入一个优先于classpath参数的URLClassLoader
 *
 * @author sixie.xyn
 * @author gaozhan
 * 
 */
@SuppressWarnings({ "unchecked" })
public class HSFMiniContainer {

    private static Map<String, Class<?>> exportedClassMap;
    private static AtomicBoolean isPandoraStarted = new AtomicBoolean(false);

    /**
     * 启动Pandora容器，并hack classloader实现pandora导出的类被优先加载
     * 
     * @param sarPath taobao-hsf.sar的路径，e.g. /Users/xiaozi/lightapi/release/taobao-hsf.sar
     * @throws Exception
     */
    public static void start(String sarPath) throws Exception {
        if(isPandoraStarted.compareAndSet(false,true)) {

            // protect the thread context class loader
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();

            HSFStarter.start(sarPath);
            Field exportedClassMapField = HSFStarter.class.getDeclaredField("exportedClassMap");
            exportedClassMapField.setAccessible(true);
            exportedClassMap = (Map<String, Class<?>>) exportedClassMapField.get(null);

            // 不让此行发生作用可以减少应用启动时log4j异常，但不相似jboss环境会导致notify单元测试测不出严重bug
            Thread.currentThread().setContextClassLoader(oldLoader);

            ClassLoader hsfClassLoader = new URLClassLoader(new URL[]{}, null) {
                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    Class<?> clazz = exportedClassMap.get(name);
                    if (clazz != null) {
                        return clazz;
                    }
                    throw new ClassNotFoundException(name);
                }
            };

            changeCurrentCloasLoaderParent(hsfClassLoader);
        }
    }

    /**
     * 设置ExtClassLoader的parent为hsfClassLoader，以便加载exportedClass
     * 
     * @param parent
     * @throws Exception
     */
    private static void changeCurrentCloasLoaderParent(ClassLoader parent) throws Exception {
        // TODO 判断SystemClassLoader是否是URLClassLoader，才强力插入
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        Field parentField = sysClass.getSuperclass().getSuperclass().getDeclaredField("parent");
        parentField.setAccessible(true);
        parentField.set(getExtClassLoader(), parent);
    }

    private static ClassLoader getExtClassLoader() {
        ClassLoader currentClassLoader = HSFMiniContainer.class.getClassLoader();
        // ExtClassLoader的parent为BootstrapClassLoader，在Java中为null
        while (currentClassLoader.getParent() != null) {
            currentClassLoader = currentClassLoader.getParent();
        }
        return currentClassLoader;
    }

    public static Set<String> getExportedClassNameList() {
        return exportedClassMap.keySet();
    }
}
