package com.taobao.hsf.standalone.util;

public class Constant {

    public static int main_version = 1;

    /**
     * taobao-hsf.tgz的最小size，10MB，这里的单位是字节
     */
    public static int MIN_TGZ_SAR_SIZE = 10 * 1024 * 1024;
    
    /**
     * 用户在 <code>com.taobao.hsf.standalone.HSFEasyStarter.setVersion(String)</code> 中指定的sar包版本号
     */
    public static ThreadLocal<String> version = new ThreadLocal<String>();

    /**
     * 用户自定义的Sar包下载base链接。如果要自己搭建下载服务器，请按下面的路径放置tgz包：
     * <ul>
     * <li>带版本号时，以版本号1.8.1.2为例，路径是：http://hsf.taobao.net/hsfversion/hsf1.8.1.2/taobao-hsf.tgz</li>
     * <li>不带版本号时，路径是：http://hsf.taobao.net/hsfversion/hsf/taobao-hsf.tgz</li>
     * </ul>
     * 此时的 <code>perferDownloadUrl</code> 为 <code>http://hsf.taobao.net/hsfversion/hsf</code>
     */
    public static ThreadLocal<String> perferDownloadUrl = new ThreadLocal<String>();

    public static final String NO_VALUE = "";

    static {
        version.set(NO_VALUE);
        perferDownloadUrl.set(NO_VALUE);
    }

    /**
     * 从HSF软件中心下载sar包的base链接，最终的下载链接为：<code>HSF_DOWNLOAD_SAR_URL[sarVersion]/taobao-hsf.tgz</code><br />
     * 以 1.8.1.2 为例，路径是：http://hsf.taobao.net/hsfversion/hsf1.8.1.2/taobao-hsf.tgz
     */
    public static final String HSF_DOWNLOAD_SAR_URL = "http://hsf.taobao.net/hsfversion/hsf";
}
