package com.taobao.hsf.standalone.util;

import java.io.File;

/**
 * 对每个IO方法都查看它throws Exception类型，对一些要关闭资源的catch住，不用关闭的由声明处的throws出去 
 * 暂时注释 throws IOException，可看哪些exception没处理
 *
 * @author gaozhan@taobao.com
 */
public class IOUtil {

    /**
     * 删除非空目录
     * 
     * @param dir
     */
    public static void deleteDir(File dir) {
        if (dir != null && dir.exists()) {
            if (dir.isDirectory()) {
                if (dir.listFiles().length == 0) {
                    dir.delete();
                } else {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; i++) {
                        if (files[i].isDirectory()) {
                            deleteDir(files[i]);
                        }
                        files[i].delete();
                    }
                }
            }
            dir.delete();
        }
    }

    /**
     * 在basePath下建立子目录subDir，并返回subDir的路径。若subDir为null或""，则subDir的路径就是basePath。
     * 
     * @param releasePath
     * @param version
     * @return subDir路径，带最后的"/"
     */
    public static String buildDirPath(String basePath, String subDir) {
        // 确保relasePath结尾不带 "/"
        if (basePath.endsWith(File.separator)) {
            basePath = basePath.substring(0, basePath.lastIndexOf(File.separator));
        }

        StringBuilder sb = new StringBuilder(basePath);
        char _ = File.separatorChar;
        if (subDir.trim().length() == 0) {
            sb.append(_);
        } else {
            sb.append(_ + subDir + _);
        }
        return sb.toString();
    }
}
