package com.taobao.hsf.standalone.util;

import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.app.spring.util.SuperHSFSpringConsumerBeanTop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public class ServiceUtil {

  public static void waitServiceReady(Object... serviceList) {
    int timePerSleep = 5;
    int totalTimeout = 15000;
    int sleepTime = 0;
    try {
      for (Object service : serviceList) {
        if (sleepTime > totalTimeout) {
          System.out.println("wait configServer pushing address timeout: " + totalTimeout + "ms");
          break;
        }

        while (! isServiceAddressReadyFromHSFSpringConsumerBean(service)) {
          Thread.sleep(timePerSleep);
          sleepTime += timePerSleep;
          if (sleepTime > totalTimeout) {
            break;
          }
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }


  private static boolean hasTarget(Object service) throws Exception {
    ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
    Object hsfProxy = Proxy.getInvocationHandler(service);
    Object metadata = invokeReadField(hsfProxy, "serviceConsumerMetadata");
    Map<String, String>
        props =
        (Map<String, String>) invokeMethodWithoutParam(metadata, "getServiceProperties");
    return props.get("target") != null;

  }


  public static boolean isServiceAddressReadyForTop(SuperHSFSpringConsumerBeanTop service)
      throws Exception {
    ClassLoader loader = SuperHSFSpringConsumerBeanTop.class.getClassLoader();
    if (Constant.main_version == 1) {
      Class
          serviceHolderClazz =
          Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true,
                        loader);
      Object metaService = invokeStaticMethodWithoutParam(serviceHolderClazz, "getMetadataService");
      Object addrService = invokeReadField(metaService, "addressService");
      Object metadata = invokeReadField(service, "metadata");
      String serviceUniqueName = (String) invokeMethodWithoutParam(metadata, "getUniqueName");
      Object
          routeResultCache =
          invokeMethodWithParam(addrService, "getRouteResultCache", serviceUniqueName);
      Object addrList = invokeMethodWithoutParam(routeResultCache, "getInterfaceAddresses");
      int size = (Integer) invokeMethodWithoutParam(addrList, "size");
      return size > 0;
    } else {
      Class
          serviceHolderClazz =
          Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
      Object addressComponent = invokeStaticMethod(serviceHolderClazz, "getInstance",
                                                   Class.forName(
                                                       "com.taobao.hsf.address.AddressService",
                                                       true, loader));
      Object addressPool = invokeReadField(addressComponent, "addressPool");
      Method m1 = service.getClass().getMethod("getInterfaceName");
      Method m2 = service.getClass().getMethod("getVersion");
      String uniqueName = m1.invoke(service, null) + ":" + m2.invoke(service, null);
      Object addressBucket = invokeMethodWithParam(addressPool, "getAddressBucket", uniqueName);
      Object addrList = invokeMethodWithoutParam(addressBucket, "getAllAddresses");
      int size = (Integer) invokeMethodWithoutParam(addrList, "size");
      return size > 0;
    }
  }

  public static boolean isServiceAddressReadyFromHSFSpringConsumerBean(Object service)
      throws Exception {
    ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();

    if (Constant.main_version == 1) {
      Class
          serviceHolderClazz =
          Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true,
                        loader);
      Object metaService = invokeStaticMethodWithoutParam(serviceHolderClazz, "getMetadataService");
      Object addrService = invokeReadField(metaService, "addressService");
      Object routeResultCache = invokeMethodWithParam(addrService, "getRouteResultCache",
                                                      getServiceUniqueNameFromServiceProxy(
                                                          service));
      Object addrList = invokeMethodWithoutParam(routeResultCache, "getInterfaceAddresses");
      int size = (Integer) invokeMethodWithoutParam(addrList, "size");
      return size > 0;
    } else {
      Class
          serviceHolderClazz =
          Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
      Object addressComponent = invokeStaticMethod(serviceHolderClazz, "getInstance",
                                                   Class.forName(
                                                       "com.taobao.hsf.address.AddressService",
                                                       true, loader));
      Object addressPool = invokeReadField(addressComponent, "addressPool");
      Object addressBucket = invokeMethodWithParam(addressPool, "getAddressBucket",
                                                   getServiceUniqueNameFromServiceProxy(service));
      Object addrList = invokeMethodWithoutParam(addressBucket, "getAllAddresses");
      int size = (Integer) invokeMethodWithoutParam(addrList, "size");
      return size > 0;
    }
  }

    /**
     * RemotingRuntimeInfoHolder这玩意里面的数值居然不是static的，坑爹
     * @return
     * @throws Exception
     */
  public static boolean isServicePublished() throws Exception {
      return false;
  }
  private static String getServiceUniqueNameFromServiceProxy(Object serviceProxy) throws Exception {
    Object hsfProxy = Proxy.getInvocationHandler(serviceProxy);
    Object metadata = invokeReadField(hsfProxy, "serviceConsumerMetadata");
    String uniqueName = (String) invokeMethodWithoutParam(metadata, "getUniqueName");
    return uniqueName;
  }

  private static Object invokeMethodWithoutParam(Object instance, String methodName)
      throws Exception {
    Method method = instance.getClass().getMethod(methodName);
    method.setAccessible(true);
    return method.invoke(instance, null);
  }

  private static Object invokeMethodWithParam(Object instance, String methodName, Object... values)
      throws Exception {
    Class[] paramTypes = new Class[values.length];
    for (int i = 0; i < values.length; i++) {
      paramTypes[i] = values[i].getClass();
    }
    Method method = instance.getClass().getDeclaredMethod(methodName, paramTypes);
    method.setAccessible(true);
    Class returnType = method.getReturnType();
    if (returnType == null) {// returnType instanceof Void
      method.invoke(instance, values);
    }
    return method.invoke(instance, values);
  }

  private static Object invokeStaticMethod(Class clazz, String methodName, Object... args)
      throws Exception {
    Class[] paramTypes = new Class[args.length];
    for (int i = 0; i < args.length; i++) {
      paramTypes[i] = args[i].getClass();
    }
    Method method = clazz.getDeclaredMethod(methodName, paramTypes);
    method.setAccessible(true);
    return method.invoke(null, args);
  }

  private static Object invokeStaticMethodWithoutParam(Class clazz, String methodName)
      throws Exception {
    Method method = clazz.getDeclaredMethod(methodName);
    method.setAccessible(true);
    return method.invoke(null, null);
  }

  private static Object invokeReadField(Object instance, String fieldName) throws Exception {
    Class clazz = instance.getClass();
    Field field = clazz.getDeclaredField(fieldName);
    field.setAccessible(true);
    return field.get(instance);
  }

  private static Object invokeGetStaticField(Class clazz, String fieldName) throws Exception {
    Field field = clazz.getDeclaredField(fieldName);
    field.setAccessible(true);
    return field.get(null);
  }

  // FIXME 临时代码
  public static void wait4DS() throws Exception {
    ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
    Class
        serviceHolderClazz =
        Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true,
                      loader);
    Object processService = invokeStaticMethodWithoutParam(serviceHolderClazz, "getProcessService");
    while (processService == null) {
      Thread.sleep(5);
      processService = invokeStaticMethodWithoutParam(serviceHolderClazz, "getProcessService");
    }
  }

}
