package com.taobao.middleware.logger.support;

import java.io.File;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LoggerHelper {

    private static final String         MORE_URL_POSFIX    = ".ERROR_CODE_MORE_URL";
    private static final String         DEFAULT_MORE_URL   = "http://console.taobao.net/help/";

    private static String               LOG_PATH           = null;
    private static final String         CONVERSION_PATTERN = "01 %d{yyyy-MM-dd HH:mm:ss.SSS} %p [%-5t:%c{2}] %m%n";

    private static Map<String, Boolean> Product_Logger_Info;
    private static Map<String, String>  Product_Logger_Pattern;

    private static Map<String, ResourceBundle> Product_Resource_Bundle;

    static {
        String dpath = System.getProperty("JM.LOG.PATH");
        if (dpath == null || dpath.trim().equals("")) {
            String defaultPath = System.getProperty("user.home");
            LOG_PATH = defaultPath + File.separator + "logs" + File.separator;
        } else {
            if (!new File(dpath).isAbsolute()) {
                throw new RuntimeException("-DJM.LOG.PATH must be an absolute path.");
            }
            if (dpath.endsWith(File.separator)) {
                LOG_PATH = dpath;
            } else {
                LOG_PATH = dpath + File.separator;
            }
        }

        LogLog.info("Log root path: " + LOG_PATH);

        Product_Logger_Info = new ConcurrentHashMap<String, Boolean>();
        Product_Logger_Pattern = new ConcurrentHashMap<String, String>();
        Product_Resource_Bundle = new ConcurrentHashMap<String, ResourceBundle>();
    }

    public static String getLogpath() {
        return LOG_PATH;
    }

    public static String getLogFile(String productName, String fileName) {
        String file = LOG_PATH + productName + File.separator + fileName;

        if (Product_Logger_Info.get(productName) == null) {
            Product_Logger_Info.put(productName, true);
            LogLog.info("Set " + productName + " log path: " + LOG_PATH + productName);
        }

        return file;
    }
    public static String getPattern(String productName) {
        String pattern = Product_Logger_Pattern.get(productName);
        if (pattern == null) {
            return CONVERSION_PATTERN;
        }

        return pattern;
    }

    public static String getPattern() {
        return CONVERSION_PATTERN;
    }

    public static void setPattern(String productName, String pattern) {
        Product_Logger_Pattern.put(productName, pattern);
    }

    public static void setResourceBundle(String productName, String bundleName) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(bundleName);
            Product_Resource_Bundle.put(productName, rb);
        } catch (Exception e) {
            LogLog.error("Failed to set " + productName + " resource bundle for: " + bundleName, e);
        }
    }

    public static String getResourceBundleString(String productName, String code) {
        if (Product_Resource_Bundle.isEmpty() || code == null || productName == null) {
            return code;
        }

        ResourceBundle rs = Product_Resource_Bundle.get(productName);
        if (rs != null) {
            try {
                String value = rs.getString(code);
                return value;
            } catch (MissingResourceException e) {
                return code;
            }
        }

        return code;
    }

    @Deprecated
    public static String getErrorCodeStr(String errorCode) {
        return "ERR-CODE: [" + errorCode + "], More: [" + "http://console.taobao.net/jm/" + errorCode + "]";
    }

    public static String getErrorCodeStr(String productName, String errorCode, String errorType, String message) {
        String moreUrl = DEFAULT_MORE_URL;
        if (productName != null) {
            String customUrl = System.getProperty(productName.toUpperCase() + MORE_URL_POSFIX);

            if (customUrl != null) {
                moreUrl = customUrl;
            }
        }

        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(" ERR-CODE: [");
        sb.append(errorCode);
        sb.append("], Type: [");
        sb.append(errorType);
        sb.append("], More: [");
        sb.append(moreUrl);
        sb.append(errorCode);
        sb.append("]");

        return sb.toString();
    }

    public static String getLogFileP(String productName, String fileName) {
        String file = getLogFile(productName, fileName);
        File logfile = new File(file);
        logfile.getParentFile().mkdirs();
        return file;
    }
}
