/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import javax.net.ssl.SSLException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientPoolUtil {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final int DEFAULT_MAX_TOTAL = 200;
    private static final int DEFAULT_MAX_PER_ROUTE = 20;
    private static final int DEFAULT_TIME_OUT = 15000;
    private static final int DEFAULT_HTTP_KEEP_TIME = 15000;
    private static final int DEFAULT_MAX_RETRY_COUNT = 5;
    private static final ConnectionKeepAliveStrategy DEFAULT_KEEP_ALIVE_STRATEGY = (response, context) -> {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement headerElement = it.nextElement();
            String param = headerElement.getName();
            String value = headerElement.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return 15000000L;
    };
    private static final HttpRequestRetryHandler retryHandler = (exception, executionCount, httpContext) -> {
        if (executionCount >= 5) {
            return false;
        }
        if (exception instanceof InterruptedIOException) {
            return false;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        return !(exception instanceof SSLException);
    };
    private static CloseableHttpClient httpClient;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri) throws SQLException {
        HttpEntity httpEntity = null;
        String responseBody = "";
        try {
            HttpRequestBase method = HttpClientPoolUtil.getRequest(uri, "GET");
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)context);
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            }
            if (httpEntity == null) return responseBody;
        }
        catch (ClientProtocolException e) {
            try {
                e.printStackTrace();
                throw TSDBError.createSQLException(8983, e.getMessage());
                catch (IOException exception) {
                    exception.printStackTrace();
                    throw TSDBError.createSQLException(8984, exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (httpEntity == null) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseBody;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri, String data, String token) throws SQLException {
        HttpEntity httpEntity = null;
        String responseBody = "";
        try {
            HttpEntityEnclosingRequestBase method = (HttpEntityEnclosingRequestBase)HttpClientPoolUtil.getRequest(uri, "POST");
            method.setHeader("Content-Type", "text/plain");
            method.setHeader("Connection", "Keep-Alive");
            method.setHeader("Authorization", "Taosd " + token);
            method.setEntity((HttpEntity)new StringEntity(data, StandardCharsets.UTF_8));
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)context);
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            }
            if (httpEntity == null) return responseBody;
        }
        catch (ClientProtocolException e) {
            try {
                e.printStackTrace();
                throw TSDBError.createSQLException(8983, e.getMessage());
                catch (IOException exception) {
                    exception.printStackTrace();
                    throw TSDBError.createSQLException(8984, exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (httpEntity == null) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseBody;
    }

    private static HttpRequestBase getRequest(String uri, String methodName) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(15000000).setConnectTimeout(15000000).setConnectionRequestTimeout(15000000).setExpectContinueEnabled(false).build();
        Object method = "PUT".equalsIgnoreCase(methodName) ? new HttpPut(uri) : ("POST".equalsIgnoreCase(methodName) ? new HttpPost(uri) : ("GET".equalsIgnoreCase(methodName) ? new HttpGet(uri) : new HttpPost(uri)));
        method.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        method.addHeader("Accept", DEFAULT_CONTENT_TYPE);
        method.setConfig(requestConfig);
        return method;
    }

    static {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(20);
        httpClient = HttpClients.custom().setKeepAliveStrategy(DEFAULT_KEEP_ALIVE_STRATEGY).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler(retryHandler).build();
    }
}

