/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.rpm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RpmPackageAssociation {
    private String name = null;
    private String version = null;
    private String minVersion = null;
    private String maxVersion = null;
    private boolean isRange = false;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String version) {
        if (version == null || version.equals("RELEASE") || version.equals("")) {
            this.isRange = false;
            this.version = null;
            this.minVersion = null;
            this.maxVersion = null;
            return;
        }
        Pattern versionPattern = Pattern.compile("\\[([0-9\\.]*),([0-9\\.]*)\\)");
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            this.isRange = true;
            this.version = null;
            String minVersion = matcher.group(1);
            String maxVersion = matcher.group(2);
            if (minVersion.equals("")) {
                minVersion = null;
            }
            if (maxVersion.equals("")) {
                maxVersion = null;
            }
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        } else {
            this.isRange = false;
            this.version = version;
            this.minVersion = null;
            this.maxVersion = null;
        }
    }

    public boolean isVersionRange() {
        return this.isRange;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }
}

